/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent;

import com.github.copilot.lang.agent.notifications.StatusNotification;
import com.github.copilot.lang.agent.rpc.JsonRPC;
import com.github.copilot.lang.agent.rpc.JsonRpcNotificationListener;
import com.github.copilot.status.CopilotStatus;
import com.github.copilot.status.CopilotStatusService;
import com.google.gson.JsonElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

class StatusChangeNotificationListener
implements JsonRpcNotificationListener {
    private static final Logger AGENT_LOG = Logger.getInstance((String)"#copilot");

    StatusChangeNotificationListener() {
    }

    @Override
    public boolean handleMessage(@NotNull String name, @NotNull JsonElement message) {
        if (!"didChangeStatus".equals(name)) {
            return false;
        }
        StatusNotification status = JsonRPC.parseResponse(message, StatusNotification.class);
        AGENT_LOG.debug("StatusChange " + String.valueOf((Object)status.getKind()) + ": " + status.getMessage());
        CopilotStatus pluginStatus = switch (status.getKind()) {
            case StatusNotification.Status.Normal -> CopilotStatus.Ready;
            case StatusNotification.Status.NotAuthorized -> CopilotStatus.NotAuthorized;
            case StatusNotification.Status.Warning -> CopilotStatus.AgentWarning;
            case StatusNotification.Status.Inactive -> CopilotStatus.Inactive;
            case StatusNotification.Status.Error -> CopilotStatus.AgentError;
            default -> throw new IllegalStateException("Unexpected status: " + String.valueOf((Object)status.getKind()));
        };
        if (status.isBusy()) {
            pluginStatus = CopilotStatus.CompletionInProgress;
        }
        CopilotStatusService.notifyApplication(pluginStatus, StringUtil.nullize((String)status.getMessage()));
        return true;
    }
}

