/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent;

import com.github.copilot.lang.agent.CopilotAgentProcessServiceEx;
import com.github.copilot.lang.agent.rpc.JsonRpcClientResponse;
import com.github.copilot.lang.agent.rpc.JsonRpcCommand;
import com.github.copilot.lang.agent.rpc.JsonRpcNotification;
import com.github.copilot.lang.agent.rpc.JsonRpcNotificationListener;
import com.github.copilot.lang.agent.rpc.JsonRpcRequestListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

final class UnavailableAgentProcessService
implements CopilotAgentProcessServiceEx {
    private static final Logger LOG = Logger.getInstance(UnavailableAgentProcessService.class);
    private final String cause;

    public UnavailableAgentProcessService(@NotNull String cause) {
        this.cause = cause;
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public void startNotify() {
    }

    @Override
    @NotNull
    public <T> CancellablePromise<T> executeCommand(@NotNull JsonRpcCommand<T> command) {
        LOG.debug("agent service is unavailable: " + this.cause + ", command: " + String.valueOf(command));
        return Promises.rejectedCancellablePromise((String)"service is unavailable");
    }

    @Override
    public void executeNotification(@NotNull JsonRpcNotification notification) {
        LOG.debug("agent service is unavailable: " + this.cause + ", notification: " + String.valueOf(notification));
    }

    @Override
    public void addNotificationListener(@NotNull Disposable parentDisposable, @NotNull JsonRpcNotificationListener listener2) {
        LOG.debug("agent service is unavailable and unable to add a listener: " + this.cause);
    }

    @Override
    public <I, O> void addRequestListener(@NotNull String lspCommand, @NotNull JsonRpcRequestListener<I, O> listener2) {
        LOG.debug("agent service is unavailable and unable to add a listener: " + this.cause);
    }

    @Override
    public void executeResponse(@NotNull JsonRpcClientResponse response) {
        LOG.debug("agent service is unavailable and unable to execute a response: " + this.cause);
    }

    @Override
    public void initialize(@NotNull Collection<JsonRpcNotificationListener> listeners) {
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void flush() {
    }
}

