/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.commands;

import com.github.copilot.lang.agent.commands.AgentStackframe;
import com.github.copilot.util.AnonymizeUtils;
import com.google.gson.annotations.SerializedName;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class AgentErrorDetail {
    @SerializedName(value="stacktrace")
    private final AgentStackframe[] frames;
    @SerializedName(value="type")
    private final String type;
    @SerializedName(value="value")
    private final String message;

    private AgentErrorDetail(String type, String message, AgentStackframe[] frames) {
        this.type = type;
        this.frames = frames;
        this.message = message;
    }

    public AgentStackframe[] getFrames() {
        return this.frames;
    }

    public String getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public static AgentErrorDetail[] from(Throwable original) {
        ArrayList<AgentErrorDetail> stacktraces = new ArrayList<AgentErrorDetail>();
        while (original != null) {
            stacktraces.add(AgentErrorDetail.asAgentStacktrace(original));
            original = original.getCause();
        }
        Collections.reverse(stacktraces);
        return stacktraces.toArray(new AgentErrorDetail[0]);
    }

    private static AgentErrorDetail asAgentStacktrace(Throwable original) {
        Object[] frames = (AgentStackframe[])Arrays.stream(original.getStackTrace()).map(AgentErrorDetail::convertStackTraceElementToAgentStacktrace).toArray(AgentStackframe[]::new);
        frames = (AgentStackframe[])ArrayUtil.reverseArray((Object[])frames);
        String redactedErrorMessage = AnonymizeUtils.redactPii(original.getMessage());
        return new AgentErrorDetail(original.getClass().getName(), redactedErrorMessage, (AgentStackframe[])frames);
    }

    private static AgentStackframe convertStackTraceElementToAgentStacktrace(StackTraceElement element) {
        AgentStackframe agentStacktrace = new AgentStackframe();
        agentStacktrace.filename = AgentErrorDetail.computeFileName(element);
        agentStacktrace.lineno = Math.max(element.getLineNumber(), 0);
        agentStacktrace.function = element.getMethodName();
        agentStacktrace.inApp = element.getClassName().contains("com.github.copilot");
        return agentStacktrace;
    }

    @NotNull
    private static String computeFileName(StackTraceElement element) {
        CharSequence[] classNameParts = element.getClassName().split("\\.");
        classNameParts[classNameParts.length - 1] = element.getFileName();
        return String.join((CharSequence)"/", classNameParts);
    }
}

