/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.commands;

import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.ssl.CertificateManager;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class AgentHttpSettings {
    @Nullable
    final String proxy;
    @Nullable
    final String proxyAuthorization;
    @Nullable
    final boolean proxyStrictSSL;
    @Nullable
    String proxyKerberosServicePrincipal;

    public static AgentHttpSettings fromPlatform() {
        HttpConfigurable proxySettings = HttpConfigurable.getInstance();
        CertificateManager.Config certificateState = CertificateManager.getInstance().getState();
        if (proxySettings.isHttpProxyEnabledForUrl("http://github.com")) {
            String proxy = "http://" + proxySettings.PROXY_HOST + ":" + Integer.toString(proxySettings.PROXY_PORT);
            Object authorization = proxySettings.getProxyLogin();
            String password = proxySettings.getPlainProxyPassword();
            if (password != null && !password.isEmpty()) {
                authorization = (String)authorization + ":" + password;
            }
            boolean strict = certificateState != null && !certificateState.ACCEPT_AUTOMATICALLY;
            return new AgentHttpSettings(proxy, (String)authorization, strict);
        }
        return new AgentHttpSettings(null, null, true);
    }

    @Generated
    public AgentHttpSettings(@Nullable String proxy, @Nullable String proxyAuthorization, @Nullable boolean proxyStrictSSL) {
        this.proxy = proxy;
        this.proxyAuthorization = proxyAuthorization;
        this.proxyStrictSSL = proxyStrictSSL;
    }

    @Nullable
    @Generated
    public String getProxy() {
        return this.proxy;
    }

    @Nullable
    @Generated
    public String getProxyAuthorization() {
        return this.proxyAuthorization;
    }

    @Nullable
    @Generated
    public boolean isProxyStrictSSL() {
        return this.proxyStrictSSL;
    }

    @Nullable
    @Generated
    public String getProxyKerberosServicePrincipal() {
        return this.proxyKerberosServicePrincipal;
    }

    @Generated
    public void setProxyKerberosServicePrincipal(@Nullable String proxyKerberosServicePrincipal) {
        this.proxyKerberosServicePrincipal = proxyKerberosServicePrincipal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgentHttpSettings)) {
            return false;
        }
        AgentHttpSettings other = (AgentHttpSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isProxyStrictSSL() != other.isProxyStrictSSL()) {
            return false;
        }
        String this$proxy = this.getProxy();
        String other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !this$proxy.equals(other$proxy)) {
            return false;
        }
        String this$proxyAuthorization = this.getProxyAuthorization();
        String other$proxyAuthorization = other.getProxyAuthorization();
        if (this$proxyAuthorization == null ? other$proxyAuthorization != null : !this$proxyAuthorization.equals(other$proxyAuthorization)) {
            return false;
        }
        String this$proxyKerberosServicePrincipal = this.getProxyKerberosServicePrincipal();
        String other$proxyKerberosServicePrincipal = other.getProxyKerberosServicePrincipal();
        return !(this$proxyKerberosServicePrincipal == null ? other$proxyKerberosServicePrincipal != null : !this$proxyKerberosServicePrincipal.equals(other$proxyKerberosServicePrincipal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AgentHttpSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isProxyStrictSSL() ? 79 : 97);
        String $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : $proxy.hashCode());
        String $proxyAuthorization = this.getProxyAuthorization();
        result = result * 59 + ($proxyAuthorization == null ? 43 : $proxyAuthorization.hashCode());
        String $proxyKerberosServicePrincipal = this.getProxyKerberosServicePrincipal();
        result = result * 59 + ($proxyKerberosServicePrincipal == null ? 43 : $proxyKerberosServicePrincipal.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AgentHttpSettings(proxy=" + this.getProxy() + ", proxyAuthorization=" + this.getProxyAuthorization() + ", proxyStrictSSL=" + this.isProxyStrictSSL() + ", proxyKerberosServicePrincipal=" + this.getProxyKerberosServicePrincipal() + ")";
    }
}

