/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.commands;

import com.github.copilot.lang.agent.SignInException;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthStatusResult {
    @SerializedName(value="status")
    @NotNull
    public Status status;
    @SerializedName(value="user")
    @Nullable
    public String user;
    @Nullable
    private String errorMessage;

    public boolean isSignedIn() {
        return this.status == Status.Ok || this.status == Status.MaybeOk;
    }

    public boolean isUnauthorized() {
        return this.status == Status.NotAuthorized;
    }

    public boolean isError() {
        return this.status == Status.FailedToGetToken || this.status == Status.TokenInvalid;
    }

    @NotNull
    public static AuthStatusResult forFailedToGetToken() {
        return new AuthStatusResult(Status.FailedToGetToken, null, null);
    }

    @NotNull
    public static AuthStatusResult forError(SignInException e) {
        return new AuthStatusResult(Status.FailedToGetToken, null, e.getMessage());
    }

    @NotNull
    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Nullable
    @Generated
    public String getUser() {
        return this.user;
    }

    @Nullable
    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public void setStatus(@NotNull Status status) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.status = status;
    }

    @Generated
    public void setUser(@Nullable String user) {
        this.user = user;
    }

    @Generated
    public void setErrorMessage(@Nullable String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthStatusResult)) {
            return false;
        }
        AuthStatusResult other = (AuthStatusResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthStatusResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthStatusResult(status=" + String.valueOf((Object)this.getStatus()) + ", user=" + this.getUser() + ", errorMessage=" + this.getErrorMessage() + ")";
    }

    @Generated
    public AuthStatusResult(@NotNull Status status, @Nullable String user, @Nullable String errorMessage) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.status = status;
        this.user = user;
        this.errorMessage = errorMessage;
    }

    public static enum Status {
        Ok("OK"),
        MaybeOk("MaybeOK"),
        NotSignedIn("NotSignedIn"),
        NotAuthorized("NotAuthorized"),
        FailedToGetToken("FailedToGetToken"),
        TokenInvalid("TokenInvalid");

        private final String id;

        private Status(String id) {
            this.id = id;
        }

        @Nullable
        static Status findById(@NotNull String id) {
            for (Status value : Status.values()) {
                if (!value.id.equals(id)) continue;
                return value;
            }
            return null;
        }
    }

    public static final class TypeAdapter
    implements JsonDeserializer<AuthStatusResult> {
        public AuthStatusResult deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject o = jsonElement.getAsJsonObject();
            String statusId = o.getAsJsonPrimitive("status").getAsString();
            String user = o.has("user") ? o.getAsJsonPrimitive("user").getAsString() : null;
            Status status = Status.findById(statusId);
            if (status == null) {
                throw new JsonParseException("unknown status id value: " + statusId);
            }
            return new AuthStatusResult(status, user, null);
        }
    }
}

