/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.commands;

import com.github.copilot.lang.agent.commands.AgentHttpSettings;
import com.github.copilot.lang.agent.commands.AuthProviderSettings;
import com.github.copilot.lang.agent.commands.CopilotSettings;
import com.github.copilot.lang.agent.commands.GitHubSettings;
import com.github.copilot.lang.agent.commands.Language;
import com.github.copilot.settings.CopilotApplicationState;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;

public class EditorSettings {
    @Nullable
    @SerializedName(value="showEditorCompletions")
    Boolean showEditorCompletions;
    @Nullable
    @SerializedName(value="enableAutoCompletions")
    Boolean enableAutoCompletions;
    @SerializedName(value="disabledLanguages")
    final List<Language> disabledLanguages = new ArrayList<Language>();
    @Nullable
    @SerializedName(value="http")
    AgentHttpSettings http;
    @Nullable
    @SerializedName(value="github-enterprise")
    AuthProviderSettings githubEnterprise;
    @Nullable
    @SerializedName(value="github")
    GitHubSettings github;

    public static EditorSettings basedOn(CopilotApplicationState settings) {
        EditorSettings agentSettings = new EditorSettings();
        agentSettings.setShowEditorCompletions(settings.isShowIdeCompletions());
        agentSettings.setEnableAutoCompletions(settings.enableCompletions);
        settings.getLanguageAllowList().getDisabledLanguageIds().forEach(agentSettings::addDisabledLanguage);
        AgentHttpSettings httpSettings = AgentHttpSettings.fromPlatform();
        httpSettings.setProxyKerberosServicePrincipal(settings.kerberosServicePrincipal);
        agentSettings.setGithub(new GitHubSettings(new CopilotSettings(settings.fetchStrategy)));
        agentSettings.setHttp(httpSettings);
        agentSettings.setGithubEnterprise(AuthProviderSettings.basedOn(settings));
        return agentSettings;
    }

    public void addDisabledLanguage(String languageId) {
        this.disabledLanguages.add(new Language(languageId));
    }

    @Generated
    public EditorSettings() {
    }

    @Nullable
    @Generated
    public Boolean getShowEditorCompletions() {
        return this.showEditorCompletions;
    }

    @Nullable
    @Generated
    public Boolean getEnableAutoCompletions() {
        return this.enableAutoCompletions;
    }

    @Generated
    public List<Language> getDisabledLanguages() {
        return this.disabledLanguages;
    }

    @Nullable
    @Generated
    public AgentHttpSettings getHttp() {
        return this.http;
    }

    @Nullable
    @Generated
    public AuthProviderSettings getGithubEnterprise() {
        return this.githubEnterprise;
    }

    @Nullable
    @Generated
    public GitHubSettings getGithub() {
        return this.github;
    }

    @Generated
    public void setShowEditorCompletions(@Nullable Boolean showEditorCompletions) {
        this.showEditorCompletions = showEditorCompletions;
    }

    @Generated
    public void setEnableAutoCompletions(@Nullable Boolean enableAutoCompletions) {
        this.enableAutoCompletions = enableAutoCompletions;
    }

    @Generated
    public void setHttp(@Nullable AgentHttpSettings http) {
        this.http = http;
    }

    @Generated
    public void setGithubEnterprise(@Nullable AuthProviderSettings githubEnterprise) {
        this.githubEnterprise = githubEnterprise;
    }

    @Generated
    public void setGithub(@Nullable GitHubSettings github) {
        this.github = github;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditorSettings)) {
            return false;
        }
        EditorSettings other = (EditorSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$showEditorCompletions = this.getShowEditorCompletions();
        Boolean other$showEditorCompletions = other.getShowEditorCompletions();
        if (this$showEditorCompletions == null ? other$showEditorCompletions != null : !((Object)this$showEditorCompletions).equals(other$showEditorCompletions)) {
            return false;
        }
        Boolean this$enableAutoCompletions = this.getEnableAutoCompletions();
        Boolean other$enableAutoCompletions = other.getEnableAutoCompletions();
        if (this$enableAutoCompletions == null ? other$enableAutoCompletions != null : !((Object)this$enableAutoCompletions).equals(other$enableAutoCompletions)) {
            return false;
        }
        List<Language> this$disabledLanguages = this.getDisabledLanguages();
        List<Language> other$disabledLanguages = other.getDisabledLanguages();
        if (this$disabledLanguages == null ? other$disabledLanguages != null : !((Object)this$disabledLanguages).equals(other$disabledLanguages)) {
            return false;
        }
        AgentHttpSettings this$http = this.getHttp();
        AgentHttpSettings other$http = other.getHttp();
        if (this$http == null ? other$http != null : !((Object)this$http).equals(other$http)) {
            return false;
        }
        AuthProviderSettings this$githubEnterprise = this.getGithubEnterprise();
        AuthProviderSettings other$githubEnterprise = other.getGithubEnterprise();
        if (this$githubEnterprise == null ? other$githubEnterprise != null : !((Object)this$githubEnterprise).equals(other$githubEnterprise)) {
            return false;
        }
        GitHubSettings this$github = this.getGithub();
        GitHubSettings other$github = other.getGithub();
        return !(this$github == null ? other$github != null : !((Object)this$github).equals(other$github));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EditorSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $showEditorCompletions = this.getShowEditorCompletions();
        result = result * 59 + ($showEditorCompletions == null ? 43 : ((Object)$showEditorCompletions).hashCode());
        Boolean $enableAutoCompletions = this.getEnableAutoCompletions();
        result = result * 59 + ($enableAutoCompletions == null ? 43 : ((Object)$enableAutoCompletions).hashCode());
        List<Language> $disabledLanguages = this.getDisabledLanguages();
        result = result * 59 + ($disabledLanguages == null ? 43 : ((Object)$disabledLanguages).hashCode());
        AgentHttpSettings $http = this.getHttp();
        result = result * 59 + ($http == null ? 43 : ((Object)$http).hashCode());
        AuthProviderSettings $githubEnterprise = this.getGithubEnterprise();
        result = result * 59 + ($githubEnterprise == null ? 43 : ((Object)$githubEnterprise).hashCode());
        GitHubSettings $github = this.getGithub();
        result = result * 59 + ($github == null ? 43 : ((Object)$github).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EditorSettings(showEditorCompletions=" + this.getShowEditorCompletions() + ", enableAutoCompletions=" + this.getEnableAutoCompletions() + ", disabledLanguages=" + String.valueOf(this.getDisabledLanguages()) + ", http=" + String.valueOf(this.getHttp()) + ", githubEnterprise=" + String.valueOf(this.getGithubEnterprise()) + ", github=" + String.valueOf(this.getGithub()) + ")";
    }
}

