/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.lsp;

import com.github.copilot.lang.agent.lsp.DidChangeWorkspaceFolders;
import com.github.copilot.lang.agent.lsp.VirtualFileUri;
import com.github.copilot.lang.agent.lsp.WorkspaceFolder;
import com.github.copilot.lang.agent.lsp.WorkspaceFoldersChangeEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public final class AgentWorkspaceFolders {
    public static DidChangeWorkspaceFolders projectAddedNotification(Project project) {
        return AgentWorkspaceFolders.folderAddedNotification(AgentWorkspaceFolders.asWorkspaceFolders(project));
    }

    public static DidChangeWorkspaceFolders projectRemovedNotification(Project project) {
        return AgentWorkspaceFolders.folderRemovedNotification(AgentWorkspaceFolders.asWorkspaceFolders(project));
    }

    public static DidChangeWorkspaceFolders moduleAddedNotification(Module module) {
        return AgentWorkspaceFolders.folderAddedNotification(AgentWorkspaceFolders.asWorkspaceFolders(module));
    }

    public static DidChangeWorkspaceFolders moduleRemovedNotification(Module module) {
        return AgentWorkspaceFolders.folderRemovedNotification(AgentWorkspaceFolders.asWorkspaceFolders(module));
    }

    public static List<WorkspaceFolder> asWorkspaceFolders(Project ... projects) {
        return Arrays.stream(projects).filter(Predicate.not(ComponentManager::isDisposed)).map(AgentWorkspaceFolders::asWorkspaceFolder).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<WorkspaceFolder> asWorkspaceFolders(Module ... modules) {
        return Arrays.stream(modules).filter(Predicate.not(Module::isDisposed)).flatMap(AgentWorkspaceFolders::asWorkspaceFolder).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static DidChangeWorkspaceFolders folderRemovedNotification(List<WorkspaceFolder> folders) {
        return new DidChangeWorkspaceFolders(new WorkspaceFoldersChangeEvent(Collections.emptyList(), folders));
    }

    private static DidChangeWorkspaceFolders folderAddedNotification(List<WorkspaceFolder> folders) {
        return new DidChangeWorkspaceFolders(new WorkspaceFoldersChangeEvent(folders, Collections.emptyList()));
    }

    @Nullable
    public static WorkspaceFolder asWorkspaceFolder(Project project) {
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        if (projectDir != null) {
            return AgentWorkspaceFolders.asWorkspaceFolder(projectDir);
        }
        return null;
    }

    private static Stream<WorkspaceFolder> asWorkspaceFolder(Module module) {
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        return Arrays.stream(contentRoots).map(AgentWorkspaceFolders::asWorkspaceFolder);
    }

    private static WorkspaceFolder asWorkspaceFolder(VirtualFile virtualFile) {
        return new WorkspaceFolder(VirtualFileUri.from(virtualFile));
    }

    private AgentWorkspaceFolders() {
    }
}

