/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.lsp;

import com.github.copilot.lang.agent.lsp.ClientCapabilities;
import com.github.copilot.lang.agent.lsp.CopilotCapabilities;
import com.github.copilot.lang.agent.lsp.InitializeResult;
import com.github.copilot.lang.agent.lsp.WorkspaceFolder;
import com.github.copilot.lang.agent.rpc.JsonRpcCommand;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InitializeCommand
implements JsonRpcCommand<InitializeResult> {
    @SerializedName(value="capabilities")
    @NotNull
    private final ClientCapabilities capabilities;
    @SerializedName(value="clientInfo")
    @NotNull
    private final NameAndVersion clientInfo;
    @SerializedName(value="initializationOptions")
    @NotNull
    private final InitializationOptions initializationOptions;
    @SerializedName(value="processId")
    @NotNull
    private final long processId;
    @SerializedName(value="workspaceFolders")
    @Nullable
    private final List<WorkspaceFolder> workspaceFolders;

    @Override
    @NotNull
    public String getCommandName() {
        return "initialize";
    }

    @Override
    @NotNull
    public Class<InitializeResult> getResponseType() {
        return InitializeResult.class;
    }

    @Generated
    public InitializeCommand(@NotNull ClientCapabilities capabilities, @NotNull NameAndVersion clientInfo, @NotNull InitializationOptions initializationOptions, @NotNull long processId, @Nullable List<WorkspaceFolder> workspaceFolders) {
        if (capabilities == null) {
            throw new NullPointerException("capabilities is marked non-null but is null");
        }
        if (clientInfo == null) {
            throw new NullPointerException("clientInfo is marked non-null but is null");
        }
        if (initializationOptions == null) {
            throw new NullPointerException("initializationOptions is marked non-null but is null");
        }
        this.capabilities = capabilities;
        this.clientInfo = clientInfo;
        this.initializationOptions = initializationOptions;
        this.processId = processId;
        this.workspaceFolders = workspaceFolders;
    }

    @NotNull
    @Generated
    public ClientCapabilities getCapabilities() {
        return this.capabilities;
    }

    @NotNull
    @Generated
    public NameAndVersion getClientInfo() {
        return this.clientInfo;
    }

    @NotNull
    @Generated
    public InitializationOptions getInitializationOptions() {
        return this.initializationOptions;
    }

    @NotNull
    @Generated
    public long getProcessId() {
        return this.processId;
    }

    @Nullable
    @Generated
    public List<WorkspaceFolder> getWorkspaceFolders() {
        return this.workspaceFolders;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InitializeCommand)) {
            return false;
        }
        InitializeCommand other = (InitializeCommand)o;
        if (this.getProcessId() != other.getProcessId()) {
            return false;
        }
        ClientCapabilities this$capabilities = this.getCapabilities();
        ClientCapabilities other$capabilities = other.getCapabilities();
        if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
            return false;
        }
        NameAndVersion this$clientInfo = this.getClientInfo();
        NameAndVersion other$clientInfo = other.getClientInfo();
        if (this$clientInfo == null ? other$clientInfo != null : !((Object)this$clientInfo).equals(other$clientInfo)) {
            return false;
        }
        InitializationOptions this$initializationOptions = this.getInitializationOptions();
        InitializationOptions other$initializationOptions = other.getInitializationOptions();
        if (this$initializationOptions == null ? other$initializationOptions != null : !((Object)this$initializationOptions).equals(other$initializationOptions)) {
            return false;
        }
        List<WorkspaceFolder> this$workspaceFolders = this.getWorkspaceFolders();
        List<WorkspaceFolder> other$workspaceFolders = other.getWorkspaceFolders();
        return !(this$workspaceFolders == null ? other$workspaceFolders != null : !((Object)this$workspaceFolders).equals(other$workspaceFolders));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $processId = this.getProcessId();
        result = result * 59 + (int)($processId >>> 32 ^ $processId);
        ClientCapabilities $capabilities = this.getCapabilities();
        result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
        NameAndVersion $clientInfo = this.getClientInfo();
        result = result * 59 + ($clientInfo == null ? 43 : ((Object)$clientInfo).hashCode());
        InitializationOptions $initializationOptions = this.getInitializationOptions();
        result = result * 59 + ($initializationOptions == null ? 43 : ((Object)$initializationOptions).hashCode());
        List<WorkspaceFolder> $workspaceFolders = this.getWorkspaceFolders();
        result = result * 59 + ($workspaceFolders == null ? 43 : ((Object)$workspaceFolders).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InitializeCommand(capabilities=" + String.valueOf(this.getCapabilities()) + ", clientInfo=" + String.valueOf(this.getClientInfo()) + ", initializationOptions=" + String.valueOf(this.getInitializationOptions()) + ", processId=" + this.getProcessId() + ", workspaceFolders=" + String.valueOf(this.getWorkspaceFolders()) + ")";
    }

    public static final class NameAndVersion {
        @SerializedName(value="name")
        @NotNull
        private final String name;
        @SerializedName(value="version")
        private final String version;
        @SerializedName(value="readableName")
        private final String readableName;

        @Generated
        public NameAndVersion(@NotNull String name, String version, String readableName) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            this.version = version;
            this.readableName = readableName;
        }

        @NotNull
        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getReadableName() {
            return this.readableName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NameAndVersion)) {
                return false;
            }
            NameAndVersion other = (NameAndVersion)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$readableName = this.getReadableName();
            String other$readableName = other.getReadableName();
            return !(this$readableName == null ? other$readableName != null : !this$readableName.equals(other$readableName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $readableName = this.getReadableName();
            result = result * 59 + ($readableName == null ? 43 : $readableName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "InitializeCommand.NameAndVersion(name=" + this.getName() + ", version=" + this.getVersion() + ", readableName=" + this.getReadableName() + ")";
        }
    }

    public static final class InitializationOptions {
        @SerializedName(value="editorInfo")
        @NotNull
        private final NameAndVersion editorInfo;
        @SerializedName(value="editorPluginInfo")
        @NotNull
        private final NameAndVersion editorPluginInfo;
        @SerializedName(value="copilotCapabilities")
        private final CopilotCapabilities copilotCapabilities;
        @SerializedName(value="githubAppId")
        private final String githubAppId;

        @Generated
        public InitializationOptions(@NotNull NameAndVersion editorInfo, @NotNull NameAndVersion editorPluginInfo, CopilotCapabilities copilotCapabilities, String githubAppId) {
            if (editorInfo == null) {
                throw new NullPointerException("editorInfo is marked non-null but is null");
            }
            if (editorPluginInfo == null) {
                throw new NullPointerException("editorPluginInfo is marked non-null but is null");
            }
            this.editorInfo = editorInfo;
            this.editorPluginInfo = editorPluginInfo;
            this.copilotCapabilities = copilotCapabilities;
            this.githubAppId = githubAppId;
        }

        @NotNull
        @Generated
        public NameAndVersion getEditorInfo() {
            return this.editorInfo;
        }

        @NotNull
        @Generated
        public NameAndVersion getEditorPluginInfo() {
            return this.editorPluginInfo;
        }

        @Generated
        public CopilotCapabilities getCopilotCapabilities() {
            return this.copilotCapabilities;
        }

        @Generated
        public String getGithubAppId() {
            return this.githubAppId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitializationOptions)) {
                return false;
            }
            InitializationOptions other = (InitializationOptions)o;
            NameAndVersion this$editorInfo = this.getEditorInfo();
            NameAndVersion other$editorInfo = other.getEditorInfo();
            if (this$editorInfo == null ? other$editorInfo != null : !((Object)this$editorInfo).equals(other$editorInfo)) {
                return false;
            }
            NameAndVersion this$editorPluginInfo = this.getEditorPluginInfo();
            NameAndVersion other$editorPluginInfo = other.getEditorPluginInfo();
            if (this$editorPluginInfo == null ? other$editorPluginInfo != null : !((Object)this$editorPluginInfo).equals(other$editorPluginInfo)) {
                return false;
            }
            CopilotCapabilities this$copilotCapabilities = this.getCopilotCapabilities();
            CopilotCapabilities other$copilotCapabilities = other.getCopilotCapabilities();
            if (this$copilotCapabilities == null ? other$copilotCapabilities != null : !((Object)this$copilotCapabilities).equals(other$copilotCapabilities)) {
                return false;
            }
            String this$githubAppId = this.getGithubAppId();
            String other$githubAppId = other.getGithubAppId();
            return !(this$githubAppId == null ? other$githubAppId != null : !this$githubAppId.equals(other$githubAppId));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NameAndVersion $editorInfo = this.getEditorInfo();
            result = result * 59 + ($editorInfo == null ? 43 : ((Object)$editorInfo).hashCode());
            NameAndVersion $editorPluginInfo = this.getEditorPluginInfo();
            result = result * 59 + ($editorPluginInfo == null ? 43 : ((Object)$editorPluginInfo).hashCode());
            CopilotCapabilities $copilotCapabilities = this.getCopilotCapabilities();
            result = result * 59 + ($copilotCapabilities == null ? 43 : ((Object)$copilotCapabilities).hashCode());
            String $githubAppId = this.getGithubAppId();
            result = result * 59 + ($githubAppId == null ? 43 : $githubAppId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "InitializeCommand.InitializationOptions(editorInfo=" + String.valueOf(this.getEditorInfo()) + ", editorPluginInfo=" + String.valueOf(this.getEditorPluginInfo()) + ", copilotCapabilities=" + String.valueOf(this.getCopilotCapabilities()) + ", githubAppId=" + this.getGithubAppId() + ")";
        }
    }
}

