/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.lsp;

import com.github.copilot.request.LineInfo;
import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.util.text.StringUtil;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class Position {
    @SerializedName(value="line")
    int line;
    @SerializedName(value="character")
    int character;

    @NotNull
    public static Position of(int line, int character) {
        return new Position(line, character);
    }

    public Position(@NotNull LineInfo lineInfo) {
        this(lineInfo.getLineNumber(), lineInfo.getColumnOffset());
    }

    public int toOffset(@NotNull String text) {
        return StringUtil.lineColToOffset((CharSequence)text, (int)this.line, (int)this.character);
    }

    @Generated
    public int getLine() {
        return this.line;
    }

    @Generated
    public int getCharacter() {
        return this.character;
    }

    @Generated
    public void setLine(int line) {
        this.line = line;
    }

    @Generated
    public void setCharacter(int character) {
        this.character = character;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Position)) {
            return false;
        }
        Position other = (Position)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLine() != other.getLine()) {
            return false;
        }
        return this.getCharacter() == other.getCharacter();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Position;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLine();
        result = result * 59 + this.getCharacter();
        return result;
    }

    @Generated
    public String toString() {
        return "Position(line=" + this.getLine() + ", character=" + this.getCharacter() + ")";
    }

    @Generated
    public Position(int line, int character) {
        this.line = line;
        this.character = character;
    }
}

