/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.lsp;

import com.github.copilot.lang.agent.unc.UncPathUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class VirtualFileUri {
    private static final Logger LOG = Logger.getInstance(VirtualFileUri.class);
    @NotNull
    private final String uri;

    @NotNull
    public static VirtualFileUri from(@NotNull VirtualFile file) {
        String uri;
        try {
            if (SystemInfo.isWindows && UncPathUtil.isFileWithUncPath(file)) {
                uri = UncPathUtil.toUriString(file);
            } else {
                String prefix = VirtualFileUri.isNeedsPathPrefix(file.getFileSystem()) ? "/" : "";
                String processedPath = VirtualFileUri.processPath(file.getPath());
                uri = new URI(file.getFileSystem().getProtocol(), "", prefix + processedPath, null).toString();
            }
        }
        catch (URISyntaxException e) {
            uri = VirtualFileUri.asPrefixedUri(file.getUrl());
            LOG.warn("Unable to parse as compliant URI, using fallback: " + uri);
        }
        return new VirtualFileUri(uri);
    }

    @NotNull
    public static VirtualFileUri from(@NotNull VirtualFileSystem fileSystem, @NotNull String path) {
        if (SystemInfo.isWindows && UncPathUtil.isUncPath(path)) {
            return new VirtualFileUri(UncPathUtil.toUriString(fileSystem, path));
        }
        String prefix = VirtualFileUri.isNeedsPathPrefix(fileSystem) && !path.startsWith("/") ? "/" : "";
        String processedPath = VirtualFileUri.processPath(path);
        return new VirtualFileUri(VirtualFileManager.constructUrl((String)fileSystem.getProtocol(), (String)(prefix + processedPath)));
    }

    @NotNull
    private static String processPath(@NotNull String path) {
        if (SystemInfo.isWindows && path.startsWith("//")) {
            return path.replace('/', '\\').replace("$", "%24");
        }
        return path;
    }

    private static boolean isNeedsPathPrefix(@NotNull VirtualFileSystem fileSystem) {
        return SystemInfo.isWindows && fileSystem instanceof LocalFileSystem && !(fileSystem instanceof TempFileSystem);
    }

    @NotNull
    static String asPrefixedUri(@NotNull String url) {
        if (SystemInfo.isWindows) {
            if (UncPathUtil.containsUncPathInUrl(url)) {
                return url;
            }
            if (url.startsWith("file://") && !url.startsWith("file:///")) {
                return "file:///" + url.substring("file://".length());
            }
        }
        return url;
    }

    @Generated
    public VirtualFileUri(@NotNull String uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.uri = uri;
    }

    @NotNull
    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VirtualFileUri)) {
            return false;
        }
        VirtualFileUri other = (VirtualFileUri)o;
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "VirtualFileUri(uri=" + this.getUri() + ")";
    }

    public static final class TypeAdapter
    implements JsonSerializer<VirtualFileUri> {
        public JsonElement serialize(VirtualFileUri file, Type type, JsonSerializationContext context) {
            return new JsonPrimitive(file.uri);
        }
    }
}

