/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.lsp;

import com.github.copilot.lang.agent.lsp.AgentWorkspaceFolders;
import com.github.copilot.lang.agent.lsp.DidChangeWorkspaceFolders;
import com.github.copilot.lsp.LSPManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.ProjectActivity;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0016\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0019\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/github/copilot/lang/agent/lsp/WorkspaceFolderListener;", "Lcom/intellij/openapi/project/ProjectManagerListener;", "Lcom/intellij/openapi/project/ModuleListener;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "projectClosed", "", "project", "Lcom/intellij/openapi/project/Project;", "projectClosing", "modulesAdded", "modules", "", "Lcom/intellij/openapi/module/Module;", "moduleRemoved", "module", "execute", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "notify", "notification", "Lcom/github/copilot/lang/agent/lsp/DidChangeWorkspaceFolders;", "isListenerEnabled", "", "notifyWhenListenerEnabled", "whenListenerEnabled", "block", "Lkotlin/Function0;", "core"})
@SourceDebugExtension(value={"SMAP\nWorkspaceFolderListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkspaceFolderListener.kt\ncom/github/copilot/lang/agent/lsp/WorkspaceFolderListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1855#2,2:44\n*S KotlinDebug\n*F\n+ 1 WorkspaceFolderListener.kt\ncom/github/copilot/lang/agent/lsp/WorkspaceFolderListener\n*L\n18#1:44,2\n*E\n"})
public final class WorkspaceFolderListener
implements ProjectManagerListener,
ModuleListener,
ProjectActivity {
    public void projectClosed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DidChangeWorkspaceFolders didChangeWorkspaceFolders = AgentWorkspaceFolders.projectRemovedNotification(project);
        Intrinsics.checkNotNullExpressionValue((Object)didChangeWorkspaceFolders, (String)"projectRemovedNotification(...)");
        this.notifyWhenListenerEnabled(didChangeWorkspaceFolders);
    }

    public void projectClosing(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DidChangeWorkspaceFolders didChangeWorkspaceFolders = AgentWorkspaceFolders.projectRemovedNotification(project);
        Intrinsics.checkNotNullExpressionValue((Object)didChangeWorkspaceFolders, (String)"projectRemovedNotification(...)");
        this.notifyWhenListenerEnabled(didChangeWorkspaceFolders);
    }

    public void modulesAdded(@NotNull Project project, @NotNull List<? extends Module> modules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        this.whenListenerEnabled((Function0<Unit>)((Function0)() -> WorkspaceFolderListener.modulesAdded$lambda$1(modules, this)));
    }

    public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        DidChangeWorkspaceFolders didChangeWorkspaceFolders = AgentWorkspaceFolders.moduleRemovedNotification(module);
        Intrinsics.checkNotNullExpressionValue((Object)didChangeWorkspaceFolders, (String)"moduleRemovedNotification(...)");
        this.notifyWhenListenerEnabled(didChangeWorkspaceFolders);
    }

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        DidChangeWorkspaceFolders didChangeWorkspaceFolders = AgentWorkspaceFolders.projectAddedNotification(project);
        Intrinsics.checkNotNullExpressionValue((Object)didChangeWorkspaceFolders, (String)"projectAddedNotification(...)");
        this.notifyWhenListenerEnabled(didChangeWorkspaceFolders);
        return Unit.INSTANCE;
    }

    private final void notify(DidChangeWorkspaceFolders notification) {
        LSPManager.getInstance().notify(notification);
    }

    private final boolean isListenerEnabled() {
        return !LSPManager.isDisabled();
    }

    private final void notifyWhenListenerEnabled(DidChangeWorkspaceFolders notification) {
        this.whenListenerEnabled((Function0<Unit>)((Function0)() -> WorkspaceFolderListener.notifyWhenListenerEnabled$lambda$2(this, notification)));
    }

    private final void whenListenerEnabled(Function0<Unit> block) {
        if (this.isListenerEnabled()) {
            block.invoke();
        }
    }

    private static final Unit modulesAdded$lambda$1(List $modules, WorkspaceFolderListener this$0) {
        Iterable $this$forEach$iv = $modules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module it = (Module)element$iv;
            boolean bl = false;
            DidChangeWorkspaceFolders didChangeWorkspaceFolders = AgentWorkspaceFolders.moduleAddedNotification(it);
            Intrinsics.checkNotNullExpressionValue((Object)didChangeWorkspaceFolders, (String)"moduleAddedNotification(...)");
            this$0.notify(didChangeWorkspaceFolders);
        }
        return Unit.INSTANCE;
    }

    private static final Unit notifyWhenListenerEnabled$lambda$2(WorkspaceFolderListener this$0, DidChangeWorkspaceFolders $notification) {
        this$0.notify($notification);
        return Unit.INSTANCE;
    }
}

