/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.notifications;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public interface LogMessage {
    public String getMessage();

    public boolean isDebug();

    public boolean isInfo();

    public boolean isWarn();

    public boolean isError();

    default public void outputMessage(@NotNull Logger logger) {
        if (this.isDebug()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                logger.debug(this.getMessage());
            } else if (logger.isTraceEnabled()) {
                logger.trace(this.getMessage());
            }
        } else if (this.isInfo()) {
            logger.info(this.getMessage());
        } else if (this.isWarn()) {
            logger.warn(this.getMessage());
        } else if (this.isError()) {
            logger.warn(this.getMessage());
        }
    }
}

