/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.rpc;

import com.github.copilot.chat.conversation.agent.context.skill.build.BuildLogsResponse;
import com.github.copilot.chat.conversation.agent.context.skill.runtime.RuntimeLogsResponse;
import com.github.copilot.chat.conversation.agent.rpc.Precondition;
import com.github.copilot.chat.conversation.agent.rpc.Reference;
import com.github.copilot.chat.conversation.agent.workspace.WatchedFileChangeType;
import com.github.copilot.lang.agent.commands.AuthStatusResult;
import com.github.copilot.lang.agent.commands.SignInInitiateResult;
import com.github.copilot.lang.agent.lsp.VirtualFileUri;
import com.github.copilot.lang.agent.lsp.textDocument.TextDocumentSyncKind;
import com.github.copilot.lang.agent.rpc.JsonRpcClientResponse;
import com.github.copilot.lang.agent.rpc.JsonRpcError;
import com.github.copilot.lang.agent.rpc.JsonRpcErrorException;
import com.github.copilot.lang.agent.rpc.JsonRpcResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import org.jetbrains.annotations.NotNull;

public final class JsonRPC {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(AuthStatusResult.class, (Object)new AuthStatusResult.TypeAdapter()).registerTypeAdapter(SignInInitiateResult.class, (Object)new SignInInitiateResult.TypeAdapter()).registerTypeAdapter(BuildLogsResponse.class, BuildLogsResponse.typeAdapter).registerTypeAdapter(RuntimeLogsResponse.class, RuntimeLogsResponse.typeAdapter).registerTypeAdapter(Precondition.class, Precondition.typeAdapter).registerTypeAdapter(Reference.class, Reference.typeAdapter).registerTypeAdapter(WatchedFileChangeType.class, WatchedFileChangeType.typeAdapter).registerTypeAdapter(TextDocumentSyncKind.class, (Object)new TextDocumentSyncKind.TypeAdapter()).registerTypeAdapter(VirtualFileUri.class, (Object)new VirtualFileUri.TypeAdapter()).create();

    private JsonRPC() {
    }

    public static String serializeCommand(int requestId, @NotNull String name, @NotNull Object command) {
        JsonObject json = new JsonObject();
        json.addProperty("jsonrpc", "2.0");
        json.addProperty("id", (Number)requestId);
        json.addProperty("method", name);
        json.add("params", GSON.toJsonTree(command));
        return GSON.toJson((JsonElement)json);
    }

    public static String serializeNotification(@NotNull String name, @NotNull Object command) {
        JsonObject json = new JsonObject();
        json.addProperty("jsonrpc", "2.0");
        json.addProperty("method", name);
        json.add("params", GSON.toJsonTree(command));
        return GSON.toJson((JsonElement)json);
    }

    public static String serializeResponse(@NotNull JsonRpcClientResponse response) {
        JsonObject json = new JsonObject();
        json.addProperty("jsonrpc", "2.0");
        json.addProperty("id", (Number)response.getRequestId());
        JsonRpcError error = response.getError();
        if (error != null) {
            json.add("error", GSON.toJsonTree((Object)error));
        } else {
            Object result = response.getResult();
            if (result == null) {
                json.add("result", GSON.toJsonTree((Object)false));
            } else {
                json.add("result", GSON.toJsonTree(result));
            }
        }
        return GSON.toJson((JsonElement)json);
    }

    @NotNull
    public static JsonRpcResponse parseResponse(@NotNull String responseContent) throws JsonRpcErrorException, JsonParseException {
        JsonObject response = (JsonObject)GSON.fromJson(responseContent, JsonObject.class);
        if (response.has("error")) {
            int id = response.getAsJsonPrimitive("id").getAsInt();
            throw new JsonRpcErrorException(id, (JsonRpcError)GSON.fromJson(response.get("error"), JsonRpcError.class));
        }
        if (JsonRPC.isServersideNotification(response)) {
            String methodName = response.getAsJsonPrimitive("method").getAsString();
            return new JsonRpcResponse(null, methodName, response.get("params"));
        }
        if (JsonRPC.isServersideRequest(response)) {
            String methodName = response.getAsJsonPrimitive("method").getAsString();
            return new JsonRpcResponse(response.getAsJsonPrimitive("id").getAsInt(), methodName, response.get("params"));
        }
        return new JsonRpcResponse(response.getAsJsonPrimitive("id").getAsInt(), null, response.get("result"));
    }

    private static boolean isServersideNotification(JsonObject response) {
        if (!response.has("id")) {
            return true;
        }
        if (response.has("method")) {
            String method = response.get("method").getAsString();
            return "client/registerCapability".equals(method);
        }
        return false;
    }

    private static boolean isServersideRequest(JsonObject response) {
        return response.has("method") && response.has("id");
    }

    @NotNull
    public static <T> T parseResponse(@NotNull JsonElement json, Class<T> responseType) throws JsonSyntaxException {
        return (T)GSON.fromJson(json, responseType);
    }
}

