/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.rpc;

import com.github.copilot.lang.agent.rpc.JsonRpcError;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonRpcErrorException
extends RuntimeException {
    private final int requestId;
    private final int code;
    private final String extraData;

    public JsonRpcErrorException(int requestId, @NotNull JsonRpcError error) {
        this(requestId, error.code, error.error, error.getData() == null ? null : error.getData().toString());
    }

    public JsonRpcErrorException(int requestId, int code, @NotNull String errorMessage, @Nullable String extraData) {
        this(requestId, code, errorMessage, extraData, null);
    }

    public JsonRpcErrorException(@NotNull String message, @NotNull JsonRpcErrorException cause) {
        this(cause.requestId, cause.code, message, cause.extraData, cause);
    }

    private JsonRpcErrorException(int requestId, int code, @NotNull String errorMessage, @Nullable String extraData, @Nullable Throwable cause) {
        super(JsonRpcErrorException.createMessage(requestId, code, errorMessage, extraData), cause);
        this.requestId = requestId;
        this.code = code;
        this.extraData = extraData;
    }

    private static String createMessage(int requestId, int code, @NotNull String errorMessage, @Nullable String extraData) {
        StringBuilder result = new StringBuilder();
        result.append(errorMessage);
        result.append(", request id: ").append(requestId);
        result.append(", error code: ").append(code);
        if (extraData != null) {
            result.append(", extra data: ").append(extraData);
        }
        return result.toString();
    }

    @Generated
    public int getRequestId() {
        return this.requestId;
    }

    @Generated
    public int getCode() {
        return this.code;
    }

    @Generated
    public String getExtraData() {
        return this.extraData;
    }
}

