/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.unc;

import com.github.copilot.lang.agent.unc.InvalidUncPathException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.net.URI;
import java.net.URISyntaxException;
import org.jetbrains.annotations.NotNull;

public class UncPathUtil {
    private static final Logger LOG = Logger.getInstance(UncPathUtil.class);

    public static boolean isUncPath(@NotNull String path) {
        return path.matches("^(\\\\\\\\|//)(?!\\\\|/).*$");
    }

    public static boolean isFileWithUncPath(@NotNull VirtualFile file) {
        return UncPathUtil.isUncPath(file.getPath());
    }

    public static boolean containsUncPathInUrl(@NotNull String url) {
        return url.contains(":////");
    }

    public static String toUriString(@NotNull VirtualFile file) {
        return UncPathUtil.toUriString(file.getFileSystem(), file.getPath());
    }

    public static String toUriString(@NotNull VirtualFileSystem fileSystem, @NotNull String path) {
        if (!UncPathUtil.isUncPath(path)) {
            throw new InvalidUncPathException(path);
        }
        String linuxStylePath = path.replace("\\", "/");
        String url = "";
        try {
            url = new URI(fileSystem.getProtocol(), "", linuxStylePath, null).toString();
        }
        catch (URISyntaxException e) {
            url = String.format("%s:%s", fileSystem.getProtocol(), linuxStylePath);
            LOG.warn("Uri parse error with protocol: " + fileSystem.getProtocol() + " and path: " + linuxStylePath, (Throwable)e);
        }
        LOG.debug("Converted UNC path to url: " + url);
        return url;
    }
}

