/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.vscodeRpc;

import com.github.copilot.lang.agent.rpc.JsonRpcMessageHandler;
import com.github.copilot.lang.agent.vscodeRpc.LimitedStringBuilder;
import com.github.copilot.lang.agent.vscodeRpc.VSCodeJsonRpcParser;
import com.github.copilot.util.LoggerUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import org.jetbrains.annotations.NotNull;

public class AgentProcessHandler
extends KillableProcessHandler {
    private static final Logger LOG = Logger.getInstance(AgentProcessHandler.class);
    private final LimitedStringBuilder recentOutput = new LimitedStringBuilder(2048);

    public AgentProcessHandler(@NotNull GeneralCommandLine cmdline, @NotNull JsonRpcMessageHandler messageHandler) throws ExecutionException {
        super(cmdline);
        final VSCodeJsonRpcParser messageParser = new VSCodeJsonRpcParser(messageHandler);
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String output = event.getText();
                if (LOG.isTraceEnabled()) {
                    LOG.trace(String.format("[%s] %s", outputType, LoggerUtil.redactAuthorizationHeader(output)));
                }
                if (outputType.equals((Object)ProcessOutputTypes.STDOUT)) {
                    messageParser.append(output);
                }
                AgentProcessHandler.this.recentOutput.append(output);
            }
        });
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        return new AgentOutputReaderOptions();
    }

    @NotNull
    public String getRecentOutput() {
        return this.recentOutput.toString();
    }

    private static class AgentOutputReaderOptions
    extends BaseOutputReader.Options {
        private AgentOutputReaderOptions() {
        }

        public BaseDataReader.SleepingPolicy policy() {
            return BaseDataReader.SleepingPolicy.BLOCKING;
        }

        public boolean splitToLines() {
            return false;
        }
    }
}

