/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.vscodeRpc;

import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

class CancellableAsyncPromise<T>
extends AsyncPromise<T> {
    private static final Logger log = Logger.getInstance(CancellableAsyncPromise.class);
    @Nullable
    private final Runnable onCancel;

    CancellableAsyncPromise(@Nullable Runnable onCancel) {
        this.onCancel = onCancel;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean isDone = this.isDone();
        boolean nowCancelled = super.cancel(mayInterruptIfRunning);
        if (!isDone && nowCancelled && this.onCancel != null) {
            try {
                this.onCancel.run();
            }
            catch (Exception e) {
                log.debug("Error calling onCancel", (Throwable)e);
            }
        }
        return nowCancelled;
    }

    public boolean setError(@NotNull Throwable error) {
        log.warn(error);
        return super.setError(error);
    }

    protected boolean shouldLogErrors() {
        return false;
    }
}

