/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.vscodeRpc;

import com.github.copilot.lang.agent.CopilotAgentProcessService;
import com.github.copilot.lang.agent.NotSignedInException;
import com.github.copilot.lang.agent.SignInException;
import com.github.copilot.lang.agent.rpc.JsonRPC;
import com.github.copilot.lang.agent.rpc.JsonRpcClientResponse;
import com.github.copilot.lang.agent.rpc.JsonRpcError;
import com.github.copilot.lang.agent.rpc.JsonRpcErrorException;
import com.github.copilot.lang.agent.rpc.JsonRpcMessageHandler;
import com.github.copilot.lang.agent.rpc.JsonRpcNotificationListener;
import com.github.copilot.lang.agent.rpc.JsonRpcRequestListener;
import com.github.copilot.lang.agent.rpc.JsonRpcResponse;
import com.github.copilot.lang.agent.vscodeRpc.CancellableAsyncPromise;
import com.github.copilot.util.LoggerUtil;
import com.google.gson.JsonElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class DefaultJsonRpcMessageHandler
implements JsonRpcMessageHandler {
    private static final Logger LOG = Logger.getInstance(DefaultJsonRpcMessageHandler.class);
    private final ExecutorService taskExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"GitHub Copilot JSON-RPC handler", (int)1);
    private final ConcurrentMap<Integer, PendingRequest<?>> pendingRequests = new ConcurrentHashMap();
    private final List<JsonRpcNotificationListener> notificationListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final ConcurrentMap<String, JsonRpcRequestListener<?, ?>> requestListeners = new ConcurrentHashMap();
    private final AtomicBoolean isShutdown = new AtomicBoolean();

    public <T> AsyncPromise<T> addPendingRequest(int requestId, @NotNull String commandName, @NotNull Class<T> responseType, @Nullable Runnable onCancel) {
        CancellableAsyncPromise promise = new CancellableAsyncPromise(onCancel);
        PendingRequest presentValue = this.pendingRequests.put(requestId, new PendingRequest(promise, responseType, commandName, System.currentTimeMillis()));
        if (presentValue != null) {
            throw new RuntimeException("Duplicate request id: " + requestId);
        }
        return promise;
    }

    public void addNotificationListeners(@NotNull Collection<JsonRpcNotificationListener> listeners) {
        this.notificationListeners.addAll(listeners);
    }

    public void removeNotificationListener(@NotNull JsonRpcNotificationListener listener2) {
        this.notificationListeners.remove(listener2);
    }

    @Override
    public void handleJsonMessage(@NotNull String message) {
        JsonRpcResponse jsonResponse;
        if (this.isShutdown.get()) {
            LOG.debug("handleJsonMessage called for shutdown message handler");
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("JSON message received: %s", LoggerUtil.redactAuthorizationHeader(message)));
        }
        long timestamp = System.currentTimeMillis();
        try {
            jsonResponse = JsonRPC.parseResponse(message);
        }
        catch (JsonRpcErrorException e) {
            this.handleErrorResponse(e);
            return;
        }
        catch (Exception e) {
            LOG.error("Error parsing JSON-RPC message: " + message, (Throwable)e);
            return;
        }
        if (jsonResponse.isNotification()) {
            this.handleNotificationMessage(jsonResponse);
        } else if (jsonResponse.isServerRequest()) {
            this.handleRequestMessage(jsonResponse);
        } else {
            this.handleCommandResponse(jsonResponse, timestamp);
        }
    }

    private void handleNotificationMessage(@NotNull JsonRpcResponse jsonResponse) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received server notification: " + jsonResponse.getNotificationName());
        }
        this.processNotification(jsonResponse);
    }

    private void sendErrorResponse(@NotNull JsonRpcResponse request, @NotNull int code, @NotNull String message) {
        JsonRpcClientResponse response = new JsonRpcClientResponse(Objects.requireNonNull(request.getNotificationName()), Objects.requireNonNull(request.getRequestId()), null, new JsonRpcError(code, message, null));
        CopilotAgentProcessService.getInstance().executeResponse(response);
    }

    private void handleRequestMessage(@NotNull JsonRpcResponse request) {
        String requestName = request.getNotificationName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received server request: " + requestName);
        }
        if (this.isShutdown.get()) {
            return;
        }
        this.taskExecutor.execute(() -> {
            assert (requestName != null);
            JsonRpcRequestListener listener2 = (JsonRpcRequestListener)this.requestListeners.get(requestName);
            if (listener2 == null) {
                LOG.warn("No method handler for " + requestName);
                this.sendErrorResponse(request, -32601, "Method not found");
            } else {
                try {
                    this.handleRequestListener(request, listener2);
                }
                catch (Exception e) {
                    LOG.warn("Error in JSON-RPC request handler", (Throwable)e);
                    this.sendErrorResponse(request, -32000, "Error in JSON-RPC request handler");
                }
            }
        });
    }

    private <I, O> void handleRequestListener(@NotNull JsonRpcResponse request, JsonRpcRequestListener<I, O> listener2) {
        Object parsedRequest;
        Class<I> requestType = listener2.getRequestType();
        Object i = parsedRequest = request.getResponse().isJsonNull() ? null : (Object)JsonRPC.parseResponse(request.getResponse(), requestType);
        if (parsedRequest != null) {
            Promise<@Nullable O> result = listener2.handleMessage(parsedRequest);
            result.onSuccess(r -> {
                JsonRpcClientResponse response = new JsonRpcClientResponse(Objects.requireNonNull(request.getNotificationName()), Objects.requireNonNull(request.getRequestId()), r, null);
                CopilotAgentProcessService.getInstance().executeResponse(response);
            });
            result.onError(e -> {
                LOG.warn("Error processing request " + request.getRequestId(), e);
                this.sendErrorResponse(request, -32001, "Error processing request: " + e.getMessage());
            });
        }
    }

    private void handleCommandResponse(@NotNull JsonRpcResponse jsonResponse, long timestamp) {
        Integer id = jsonResponse.getRequestId();
        assert (id != null);
        PendingRequest pending = (PendingRequest)this.pendingRequests.remove(id);
        if (pending == null) {
            LOG.error("received unexpected response data for id: " + id + ", response: " + String.valueOf(jsonResponse));
            return;
        }
        try {
            this.traceResponse(jsonResponse, timestamp, pending);
            Object parsedResponse = jsonResponse.getResponse().isJsonNull() ? null : JsonRPC.parseResponse(jsonResponse.getResponse(), pending.resultType);
            this.taskExecutor.submit(() -> {
                AsyncPromise promise = pending.promise;
                promise.setResult(parsedResponse);
            });
        }
        catch (Exception e) {
            LOG.error("Error processing response of the agent", (Throwable)e);
            ApplicationManager.getApplication().executeOnPooledThread(() -> pending.promise.setError((Throwable)e));
        }
    }

    private void traceResponse(@NotNull JsonRpcResponse jsonResponse, long timestamp, PendingRequest<?> pending) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("[%d] Response received. Command: %s, duration: %d ms, response: %s", jsonResponse.getRequestId(), pending.commandName, timestamp - pending.startTimestamp, jsonResponse.getResponse()));
        }
    }

    private void handleErrorResponse(@NotNull JsonRpcErrorException e) {
        int id = e.getRequestId();
        String message = e.getMessage();
        LOG.debug("received JSON-RPC error. id: " + id + ", error: " + message);
        PendingRequest pending = (PendingRequest)this.pendingRequests.remove(id);
        if (pending == null) {
            LOG.warn("no pending response found for request ID " + id, (Throwable)e);
            return;
        }
        RuntimeException mappedError = message.contains("NotSignedIn") ? new NotSignedInException(id) : (pending.commandName.equals("signInConfirm") ? new SignInException(e.getMessage()) : new JsonRpcErrorException("Error processing command " + pending.commandName, e));
        ApplicationManager.getApplication().executeOnPooledThread(() -> pending.promise.setError((Throwable)mappedError));
    }

    private void processNotification(@NotNull JsonRpcResponse notification) {
        if (this.isShutdown.get()) {
            return;
        }
        this.taskExecutor.execute(() -> {
            String name = notification.getNotificationName();
            JsonElement message = notification.getResponse();
            assert (name != null);
            for (JsonRpcNotificationListener listener2 : this.notificationListeners) {
                try {
                    if (!listener2.handleMessage(name, message)) continue;
                    break;
                }
                catch (Exception e) {
                    LOG.error("error in JSON-RPC notification handler", (Throwable)e);
                }
            }
        });
    }

    public <I> void shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            throw new IllegalStateException("message handler was already shutdown");
        }
        if (this.taskExecutor instanceof BoundedTaskExecutor) {
            try {
                ((BoundedTaskExecutor)this.taskExecutor).clearAndCancelAll();
            }
            catch (Exception e) {
                LOG.debug("Error calling clearAndCancelAll", (Throwable)e);
            }
        }
        this.taskExecutor.shutdown();
    }

    public <I, O> void addRequestListener(String lspCommand, JsonRpcRequestListener<I, O> listener2) {
        this.requestListeners.put(lspCommand, listener2);
    }

    private static final class PendingRequest<T> {
        private final AsyncPromise<T> promise;
        private final Class<T> resultType;
        private final String commandName;
        private final long startTimestamp;

        @Generated
        public PendingRequest(AsyncPromise<T> promise, Class<T> resultType, String commandName, long startTimestamp) {
            this.promise = promise;
            this.resultType = resultType;
            this.commandName = commandName;
            this.startTimestamp = startTimestamp;
        }

        @Generated
        public AsyncPromise<T> getPromise() {
            return this.promise;
        }

        @Generated
        public Class<T> getResultType() {
            return this.resultType;
        }

        @Generated
        public String getCommandName() {
            return this.commandName;
        }

        @Generated
        public long getStartTimestamp() {
            return this.startTimestamp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PendingRequest)) {
                return false;
            }
            PendingRequest other = (PendingRequest)o;
            if (this.getStartTimestamp() != other.getStartTimestamp()) {
                return false;
            }
            AsyncPromise<T> this$promise = this.getPromise();
            AsyncPromise<T> other$promise = other.getPromise();
            if (this$promise == null ? other$promise != null : !this$promise.equals(other$promise)) {
                return false;
            }
            Class<T> this$resultType = this.getResultType();
            Class<T> other$resultType = other.getResultType();
            if (this$resultType == null ? other$resultType != null : !this$resultType.equals(other$resultType)) {
                return false;
            }
            String this$commandName = this.getCommandName();
            String other$commandName = other.getCommandName();
            return !(this$commandName == null ? other$commandName != null : !this$commandName.equals(other$commandName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $startTimestamp = this.getStartTimestamp();
            result = result * 59 + (int)($startTimestamp >>> 32 ^ $startTimestamp);
            AsyncPromise<T> $promise = this.getPromise();
            result = result * 59 + ($promise == null ? 43 : $promise.hashCode());
            Class<T> $resultType = this.getResultType();
            result = result * 59 + ($resultType == null ? 43 : $resultType.hashCode());
            String $commandName = this.getCommandName();
            result = result * 59 + ($commandName == null ? 43 : $commandName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultJsonRpcMessageHandler.PendingRequest(promise=" + String.valueOf(this.getPromise()) + ", resultType=" + String.valueOf(this.getResultType()) + ", commandName=" + this.getCommandName() + ", startTimestamp=" + this.getStartTimestamp() + ")";
        }
    }
}

