/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.vscodeRpc;

import com.github.copilot.lang.agent.rpc.JsonRPC;
import com.github.copilot.lang.agent.rpc.JsonRpcClientResponse;
import com.github.copilot.lang.agent.rpc.JsonRpcCommand;
import com.github.copilot.lang.agent.rpc.JsonRpcNotification;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public final class VSCodeJsonRpc {
    private static final Logger LOG = Logger.getInstance(VSCodeJsonRpc.class);

    private VSCodeJsonRpc() {
    }

    public static void sendCommand(@NotNull OutputStream target, int id, @NotNull JsonRpcCommand<?> command) throws IOException {
        String name = command.getCommandName();
        String commandJSON = JsonRPC.serializeCommand(id, name, command);
        VSCodeJsonRpc.sendBytes(target, commandJSON);
    }

    public static void sendNotification(@NotNull OutputStream target, @NotNull JsonRpcNotification notification) throws IOException {
        String name = notification.getCommandName();
        String notificationJSON = JsonRPC.serializeNotification(name, notification);
        VSCodeJsonRpc.sendBytes(target, notificationJSON);
    }

    public static void sendResponse(@NotNull OutputStream target, @NotNull JsonRpcClientResponse response) throws IOException {
        String responseJson = JsonRPC.serializeResponse(response);
        VSCodeJsonRpc.sendBytes(target, responseJson);
    }

    private static void sendBytes(@NotNull OutputStream target, @NotNull String commandJSON) throws IOException {
        byte[] commandBytes = commandJSON.getBytes(StandardCharsets.UTF_8);
        String header = "Content-Length: " + commandBytes.length + "\r\n\r\n";
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sending JSON-RPC message:\n" + header + commandJSON);
        }
        target.write(header.getBytes(StandardCharsets.UTF_8));
        target.write(commandBytes);
        target.flush();
    }
}

