/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lang.agent.vscodeRpc;

import com.github.copilot.lang.agent.rpc.JsonRpcMessageHandler;
import com.github.copilot.lang.agent.vscodeRpc.ByteArray;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.charset.StandardCharsets;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@ThreadSafe
class VSCodeJsonRpcParser {
    private static final Logger LOG = Logger.getInstance(VSCodeJsonRpcParser.class);
    private static final byte[] CONTENT_LENGTH = "Content-Length: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] SEPARATOR = "\r\n\r\n".getBytes(StandardCharsets.UTF_8);
    private final JsonRpcMessageHandler messageHandler;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private int pendingContentLength = 0;
    @GuardedBy(value="lock")
    private final ByteArray pendingContent = new ByteArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    @NotNull
    public String getPendingContent() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingContent.toString(StandardCharsets.UTF_8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(@NotNull String content) {
        Object object = this.lock;
        synchronized (object) {
            this.appendLocked(content);
        }
    }

    private void handleContentLengthMessage() {
        assert (this.pendingContentLength == 0);
        int lineEnd = this.pendingContent.indexOf(SEPARATOR);
        if (lineEnd > 0) {
            String line = new String(this.pendingContent.getBytes(CONTENT_LENGTH.length, lineEnd), StandardCharsets.UTF_8);
            this.pendingContent.deleteFirst(lineEnd + SEPARATOR.length);
            int length = Integer.parseInt(line, 0, line.length(), 10);
            LOG.debug("Found content-length: " + line);
            this.pendingContentLength += length;
        }
    }

    private void appendLocked(@NotNull String content) {
        this.pendingContent.add(content.getBytes(StandardCharsets.UTF_8));
        do {
            if (this.pendingContent.indexOf(CONTENT_LENGTH) != 0) continue;
            this.handleContentLengthMessage();
        } while (this.pendingContentLength > 0 && this.processPendingContent());
    }

    private boolean processPendingContent() {
        if (this.pendingContent.size() < this.pendingContentLength) {
            return false;
        }
        String message = this.pendingContent.toString(0, this.pendingContentLength, StandardCharsets.UTF_8);
        this.pendingContent.deleteFirst(this.pendingContentLength);
        this.pendingContentLength = 0;
        this.messageHandler.handleJsonMessage(message);
        return true;
    }

    @Generated
    public VSCodeJsonRpcParser(JsonRpcMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }
}

