/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lsp;

import com.github.copilot.lsp.LSPManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.messages.Topic;
import java.util.List;
import lombok.Generated;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LSPAsyncFileChangesListener
implements AsyncFileListener {
    public static final Topic<Runnable> TOPIC_AFTER_VFS_CHANGE = Topic.create((String)"afterVfsChange", Runnable.class);

    @Nullable
    public LSPChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        if (LSPManager.isDisabled()) {
            return null;
        }
        List refreshEvents = ((StreamEx)((StreamEx)StreamEx.ofReversed(events).filter(this::isSupportedEvent)).distinct(VFileEvent::getPath)).toList();
        return refreshEvents.isEmpty() ? null : new LSPChangeApplier(refreshEvents);
    }

    private boolean isSupportedEvent(@NotNull VFileEvent e) {
        return e.isFromRefresh() || e instanceof VFileMoveEvent || e instanceof VFilePropertyChangeEvent;
    }

    static class LSPChangeApplier
    implements AsyncFileListener.ChangeApplier {
        private static final Logger LOG = Logger.getInstance(LSPChangeApplier.class);
        private final List<? extends VFileEvent> refreshEvents;

        public void afterVfsChange() {
            ApplicationManager.getApplication().executeOnPooledThread(this::afterVfsChangeAsync);
        }

        void afterVfsChangeAsync() {
            LOG.debug("afterVfsChange:", new Object[]{this.refreshEvents.size()});
            LSPManager manager = LSPManager.getInstance();
            for (VFileEvent vFileEvent : this.refreshEvents) {
                this.handleEvent(manager, vFileEvent);
            }
            ((Runnable)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC_AFTER_VFS_CHANGE)).run();
        }

        private void handleEvent(@NotNull LSPManager manager, @NotNull VFileEvent event) {
            if (event instanceof VFileContentChangeEvent) {
                this.handleContentChangeEvent(manager, (VFileContentChangeEvent)event);
            } else if (event instanceof VFileDeleteEvent) {
                this.handleDeleteEvent(manager, (VFileDeleteEvent)event);
            } else if (event instanceof VFileMoveEvent) {
                this.handleMoveEvent(manager, (VFileMoveEvent)event);
            } else if (event instanceof VFilePropertyChangeEvent) {
                this.handlePropertyChangeEvent(manager, (VFilePropertyChangeEvent)event);
            }
        }

        private void handleDeleteEvent(@NotNull LSPManager manager, @NotNull VFileDeleteEvent event) {
            manager.notifyDidClose(event.getFile());
        }

        private void handleContentChangeEvent(@NotNull LSPManager manager, @NotNull VFileContentChangeEvent event) {
            manager.notifyDidChange(event.getFile());
        }

        private void handleMoveEvent(@NotNull LSPManager manager, @NotNull VFileMoveEvent event) {
            Project project;
            VirtualFile file = event.getFile();
            manager.notifyDidClose(file, event.getOldPath());
            if (file.isValid() && (project = ProjectUtil.guessProjectForFile((VirtualFile)file)) != null) {
                manager.notifyDidOpen(project, file);
            }
        }

        private void handlePropertyChangeEvent(@NotNull LSPManager manager, @NotNull VFilePropertyChangeEvent event) {
            Project project;
            if (!"name".equals(event.getPropertyName())) {
                return;
            }
            VirtualFile file = event.getFile();
            manager.notifyDidClose(file, event.getOldPath());
            if (file.isValid() && (project = ProjectUtil.guessProjectForFile((VirtualFile)file)) != null) {
                manager.notifyDidOpen(project, file);
            }
        }

        @Generated
        public LSPChangeApplier(List<? extends VFileEvent> refreshEvents) {
            this.refreshEvents = refreshEvents;
        }

        @Generated
        public List<? extends VFileEvent> getRefreshEvents() {
            return this.refreshEvents;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LSPChangeApplier)) {
                return false;
            }
            LSPChangeApplier other = (LSPChangeApplier)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<? extends VFileEvent> this$refreshEvents = this.getRefreshEvents();
            List<? extends VFileEvent> other$refreshEvents = other.getRefreshEvents();
            return !(this$refreshEvents == null ? other$refreshEvents != null : !((Object)this$refreshEvents).equals(other$refreshEvents));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LSPChangeApplier;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<? extends VFileEvent> $refreshEvents = this.getRefreshEvents();
            result = result * 59 + ($refreshEvents == null ? 43 : ((Object)$refreshEvents).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LSPAsyncFileChangesListener.LSPChangeApplier(refreshEvents=" + String.valueOf(this.getRefreshEvents()) + ")";
        }
    }
}

