/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lsp;

import com.github.copilot.lsp.LSPManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileOpenedSyncListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/github/copilot/lsp/LSPEditorListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "Lcom/intellij/openapi/fileEditor/FileOpenedSyncListener;", "<init>", "()V", "fileOpenedSync", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editorsWithProviders", "", "Lcom/intellij/openapi/fileEditor/ex/FileEditorWithProvider;", "fileClosed", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "determineFile", "getVirtualFileFromDocument", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "backup", "core"})
@SourceDebugExtension(value={"SMAP\nLSPEditorListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LSPEditorListener.kt\ncom/github/copilot/lsp/LSPEditorListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n3792#2:38\n4307#2,2:39\n800#3,11:41\n1549#3:52\n1620#3,3:53\n*S KotlinDebug\n*F\n+ 1 LSPEditorListener.kt\ncom/github/copilot/lsp/LSPEditorListener\n*L\n30#1:38\n30#1:39,2\n31#1:41,11\n32#1:52\n32#1:53,3\n*E\n"})
public final class LSPEditorListener
implements FileEditorManagerListener,
FileOpenedSyncListener {
    public void fileOpenedSync(@NotNull FileEditorManager source, @NotNull VirtualFile file, @NotNull List<FileEditorWithProvider> editorsWithProviders) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(editorsWithProviders, (String)"editorsWithProviders");
        VirtualFile virtualFile = this.determineFile(source, file);
        LSPManager.getInstance().notifyDidOpen(source.getProject(), virtualFile);
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LSPManager.getInstance().notifyDidClose(this.determineFile(source, file));
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getNewFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile focusedFile = virtualFile;
        LSPManager.getInstance().notifyDidFocus(event.getManager().getProject(), this.determineFile(event.getManager(), focusedFile));
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile determineFile(FileEditorManager source, VirtualFile file) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        FileEditor[] fileEditorArray = source.getEditors(file);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getEditors(...)");
        Object[] $this$filter$iv = fileEditorArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (TextEditor element$iv$iv : $this$filterTo$iv$iv) {
            FileEditor it = (FileEditor)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFile(), (Object)file)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$filterTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TextEditor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TextEditor element$iv$iv;
            element$iv$iv = (TextEditor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getVirtualFileFromDocument((TextEditor)it, file));
        }
        VirtualFile virtualFile = (VirtualFile)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (virtualFile == null) {
            virtualFile = file;
        }
        return virtualFile;
    }

    private final VirtualFile getVirtualFileFromDocument(TextEditor editor, VirtualFile backup) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getEditor().getDocument());
        if (virtualFile == null) {
            virtualFile = backup;
        }
        return virtualFile;
    }
}

