/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lsp;

import com.github.copilot.lang.LanguageInfo;
import com.github.copilot.lang.LanguageInfoManager;
import com.github.copilot.lang.agent.CopilotAgent;
import com.github.copilot.lang.agent.CopilotAgentProcessService;
import com.github.copilot.lang.agent.commands.ConfigurationChangeCommand;
import com.github.copilot.lang.agent.commands.EditorSettings;
import com.github.copilot.lang.agent.lsp.Position;
import com.github.copilot.lang.agent.lsp.Range;
import com.github.copilot.lang.agent.lsp.VirtualFileUri;
import com.github.copilot.lang.agent.lsp.textDocument.DidChangeCommand;
import com.github.copilot.lang.agent.lsp.textDocument.DidCloseCommand;
import com.github.copilot.lang.agent.lsp.textDocument.DidFocusCommand;
import com.github.copilot.lang.agent.lsp.textDocument.DidOpenCommand;
import com.github.copilot.lang.agent.lsp.textDocument.TextDocumentContentChangeEvent;
import com.github.copilot.lang.agent.lsp.textDocument.TextDocumentItem;
import com.github.copilot.lang.agent.lsp.textDocument.VersionedTextDocumentIdentifier;
import com.github.copilot.lang.agent.rpc.JsonRpcNotification;
import com.github.copilot.lsp.LSPUtil;
import com.github.copilot.util.FileSizeUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LSPManager {
    private static final Logger LOG = Logger.getInstance(LSPManager.class);
    private static final Key<Integer> KEY_FILE_OPENED = Key.create((String)"copilot.lspOpen");
    private final AtomicInteger agentProcessId = new AtomicInteger(0);

    @NotNull
    public static LSPManager getInstance() {
        return (LSPManager)ApplicationManager.getApplication().getService(LSPManager.class);
    }

    public void notifyDidOpen(@NotNull Project project, @NotNull VirtualFile file) {
        if (FileSizeUtil.isTooLarge(file)) {
            return;
        }
        LanguageInfo language = this.findLanguageInfo(project, file);
        if (language == null) {
            return;
        }
        this.doNotifyDidOpen(file, language);
    }

    public void notifyDidClose(@NotNull VirtualFile file) {
        this.notifyDidClose(file, null);
    }

    public void notifyDidClose(@NotNull VirtualFile file, @Nullable String pathOverride) {
        if (LSPManager.isDisabled()) {
            return;
        }
        Integer storedId = (Integer)KEY_FILE_OPENED.get((UserDataHolder)file);
        if (storedId != null && storedId.intValue() == this.agentProcessId.get()) {
            KEY_FILE_OPENED.set((UserDataHolder)file, null);
            if (pathOverride != null) {
                this.notify(new DidCloseCommand(LSPUtil.identifier(file.getFileSystem(), pathOverride)));
            } else {
                this.notify(new DidCloseCommand(LSPUtil.identifier(file)));
            }
        }
    }

    public void notifyDidFocus(@NotNull Project project, @NotNull VirtualFile file) {
        if (FileSizeUtil.isTooLarge(file)) {
            return;
        }
        LanguageInfo language = this.findLanguageInfo(project, file);
        if (language == null) {
            return;
        }
        this.doNotifyDidOpen(file, language);
        this.notify(new DidFocusCommand(VirtualFileUri.from(file)));
    }

    public void notifyDidChange(@NotNull DocumentEvent event) {
        if (LSPManager.isDisabled()) {
            return;
        }
        Document doc = event.getDocument();
        VirtualFile file = FileDocumentManager.getInstance().getFile(doc);
        if (file == null || !file.isValid()) {
            return;
        }
        if (!this.checkFileStatus(file)) {
            return;
        }
        if (event.isWholeTextReplaced()) {
            this.doNotifyDidChangeComplete(doc);
        } else {
            this.doNotifyDidChangePartial(doc, event);
        }
    }

    public void notifyDidChange(@NotNull VirtualFile file) {
        if (LSPManager.isDisabled() || !file.isValid()) {
            return;
        }
        if (!this.checkFileStatus(file)) {
            return;
        }
        Document doc = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(file));
        if (doc == null) {
            return;
        }
        this.doNotifyDidChangeComplete(doc);
    }

    public void notifyConfigurationChanged(EditorSettings settings) {
        if (LSPManager.isDisabled()) {
            return;
        }
        this.notify(new ConfigurationChangeCommand(settings));
    }

    public void notify(@NotNull JsonRpcNotification notification) {
        if (LSPManager.isDisabled()) {
            return;
        }
        CopilotAgentProcessService.getInstance().executeNotification(notification);
    }

    @RequiresBackgroundThread
    void afterAgentRestart() {
        if (LSPManager.isDisabled()) {
            return;
        }
        this.agentProcessId.incrementAndGet();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (project.isDisposed()) continue;
            for (VirtualFile file : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
                this.notifyDidOpen(project, file);
            }
        }
    }

    private void doNotifyDidOpen(@NotNull VirtualFile file, @NotNull LanguageInfo language) {
        int currentId = this.agentProcessId.get();
        Integer storedId = (Integer)KEY_FILE_OPENED.get((UserDataHolder)file);
        if (storedId == null || storedId != currentId) {
            KEY_FILE_OPENED.set((UserDataHolder)file, (Object)currentId);
            TextDocumentItem textDocument = (TextDocumentItem)ReadAction.compute(() -> LSPUtil.createTextDocument(file, language));
            if (textDocument == null) {
                LOG.warn("failed to create text document for newly opened file: " + String.valueOf(file));
            } else {
                this.notify(new DidOpenCommand(textDocument));
            }
        }
    }

    private void doNotifyDidChangeComplete(@NotNull Document doc) {
        VersionedTextDocumentIdentifier textDocument = LSPUtil.versionedIdentifier(doc);
        if (textDocument == null) {
            return;
        }
        this.notify(new DidChangeCommand(textDocument, new TextDocumentContentChangeEvent(doc.getText())));
    }

    private void doNotifyDidChangePartial(@NotNull Document doc, @NotNull DocumentEvent event) {
        VersionedTextDocumentIdentifier textDocument = LSPUtil.versionedIdentifier(doc);
        if (textDocument == null) {
            return;
        }
        Position startPosition = LSPUtil.position(doc, event.getOffset());
        Position endPosition = LSPUtil.shiftByText(startPosition, event.getOldFragment());
        String fragment = event.getNewFragment().toString();
        Range range = Range.of(startPosition, endPosition);
        this.notify(new DidChangeCommand(textDocument, new TextDocumentContentChangeEvent(fragment, range)));
    }

    @Nullable
    private LanguageInfo findLanguageInfo(@NotNull Project project, @NotNull VirtualFile file) {
        if (LSPManager.isDisabled() || !file.isValid()) {
            return null;
        }
        return (LanguageInfo)ReadAction.compute(() -> LanguageInfoManager.findLanguage(project, file));
    }

    private boolean checkFileStatus(@NotNull VirtualFile file) {
        Integer storedId = (Integer)KEY_FILE_OPENED.get((UserDataHolder)file);
        if (storedId == null) {
            return false;
        }
        if (storedId.intValue() != this.agentProcessId.get()) {
            Project guessedProject = LSPManager.guessProject(file);
            if (guessedProject != null) {
                LanguageInfo languageInfo = (LanguageInfo)ReadAction.compute(() -> LanguageInfoManager.findLanguage(guessedProject, file));
                this.doNotifyDidOpen(file, languageInfo);
            }
            return false;
        }
        return true;
    }

    @Nullable
    private static Project guessProject(@NotNull VirtualFile file) {
        Project project;
        FileViewProvider cachedPsi;
        if (file instanceof LightVirtualFile && (cachedPsi = FileDocumentManager.getInstance().findCachedPsiInAnyProject(file)) != null && !(project = cachedPsi.getManager().getProject()).isDisposed()) {
            return project;
        }
        return ProjectUtil.guessProjectForContentFile((VirtualFile)file);
    }

    public static boolean isDisabled() {
        return !CopilotAgent.isAgentSupported();
    }
}

