/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.lsp;

import com.github.copilot.editor.CopilotEditorUtil;
import com.github.copilot.lang.LanguageInfo;
import com.github.copilot.lang.agent.lsp.Position;
import com.github.copilot.lang.agent.lsp.VirtualFileUri;
import com.github.copilot.lang.agent.lsp.textDocument.TextDocumentIdentifier;
import com.github.copilot.lang.agent.lsp.textDocument.TextDocumentItem;
import com.github.copilot.lang.agent.lsp.textDocument.VersionedTextDocumentIdentifier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LSPUtil {
    private LSPUtil() {
    }

    @NotNull
    static TextDocumentIdentifier identifier(@NotNull VirtualFile file) {
        return new TextDocumentIdentifier(VirtualFileUri.from(file));
    }

    @NotNull
    static TextDocumentIdentifier identifier(@NotNull VirtualFileSystem fileSystem, @NotNull String path) {
        return new TextDocumentIdentifier(VirtualFileUri.from(fileSystem, path));
    }

    @RequiresReadLock
    @Nullable
    static TextDocumentItem createTextDocument(@NotNull VirtualFile file, @NotNull LanguageInfo language) {
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return null;
        }
        return new TextDocumentItem(VirtualFileUri.from(file), language.getId(), LSPUtil.version(document), document.getText());
    }

    public static int version(@NotNull Document document) {
        return (int)CopilotEditorUtil.getDocumentModificationStamp(document);
    }

    @Nullable
    static VersionedTextDocumentIdentifier versionedIdentifier(@NotNull Document doc) {
        VirtualFile file = FileDocumentManager.getInstance().getFile(doc);
        if (file == null) {
            return null;
        }
        return new VersionedTextDocumentIdentifier(VirtualFileUri.from(file), LSPUtil.version(doc));
    }

    @NotNull
    static Position position(@NotNull Document document, int offset) {
        int line = document.getLineNumber(offset);
        int lineStart = document.getLineStartOffset(line);
        int column = offset - lineStart;
        assert (column >= 0);
        return new Position(line, column);
    }

    @NotNull
    static Position shiftByText(@NotNull Position position, @NotNull CharSequence text) {
        if (text.length() == 0) {
            return position;
        }
        LineColumn offset = StringUtil.offsetToLineColumn((CharSequence)text, (int)text.length());
        int line = offset.line;
        int column = line == 0 ? position.getCharacter() + offset.column : offset.column;
        return Position.of(position.getLine() + line, column);
    }
}

