/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.onboarding;

import com.intellij.util.ui.JBUI;
import java.awt.Cursor;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/github/copilot/onboarding/KeyboardAccessibleLabel;", "Ljavax/swing/JLabel;", "labelText", "", "action", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getAction", "()Lkotlin/jvm/functions/Function0;", "setAction", "(Lkotlin/jvm/functions/Function0;)V", "core"})
public final class KeyboardAccessibleLabel
extends JLabel {
    @NotNull
    private Function0<Unit> action;

    public KeyboardAccessibleLabel(@NotNull String labelText, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)labelText, (String)"labelText");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.action = action2;
        this.setText(labelText);
        this.setFocusable(true);
        final Border defaultBorder = BorderFactory.createEmptyBorder(4, 2, 4, 2);
        this.setBorder(defaultBorder);
        this.setCursor(Cursor.getPredefinedCursor(12));
        AccessibleContext accessibleContext = this.accessibleContext = this.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleDescription("Link");
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, JBUI.CurrentTheme.Focus.focusColor()), BorderFactory.createEmptyBorder(2, 0, 2, 0)));
            }

            @Override
            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setBorder(defaultBorder);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    this.getAction().invoke();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.getAction().invoke();
            }
        });
    }

    @NotNull
    public final Function0<Unit> getAction() {
        return this.action;
    }

    public final void setAction(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.action = function0;
    }
}

