/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.onboarding;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotIcons;
import com.github.copilot.featureflags.CopilotFeatureFlags;
import com.github.copilot.featureflags.CopilotFeatureFlagsListener;
import com.github.copilot.onboarding.BannerPanel;
import com.github.copilot.onboarding.pages.ChatPage;
import com.github.copilot.onboarding.pages.ConfigurePage;
import com.github.copilot.onboarding.pages.LearnMorePage;
import com.github.copilot.onboarding.pages.Page;
import com.github.copilot.onboarding.pages.PageProgress;
import com.github.copilot.onboarding.pages.ProgressAction;
import com.github.copilot.onboarding.pages.SuggestionsPage;
import com.github.copilot.onboarding.pages.WelcomePage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000f2\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/github/copilot/onboarding/OnboardingPanel;", "Ljavax/swing/JPanel;", "Lcom/github/copilot/featureflags/CopilotFeatureFlagsListener;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "<init>", "(Lcom/intellij/openapi/wm/ToolWindow;)V", "banner", "Lcom/github/copilot/onboarding/BannerPanel;", "getBanner", "()Lcom/github/copilot/onboarding/BannerPanel;", "cardLayout", "Ljava/awt/CardLayout;", "steps", "", "", "Lcom/github/copilot/onboarding/pages/Page;", "pageContent", "updateSteps", "", "onFeatureFlags", "featureFlags", "Lcom/github/copilot/featureflags/CopilotFeatureFlags;", "showStep", "stepName", "requestFocus", "", "Companion", "core"})
public final class OnboardingPanel
extends JPanel
implements CopilotFeatureFlagsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BannerPanel banner;
    @NotNull
    private final CardLayout cardLayout;
    @NotNull
    private final Map<String, Page> steps;
    @NotNull
    private final JPanel pageContent;
    @NotNull
    public static final String WELCOME = "Welcome";
    @NotNull
    public static final String SUGGESTIONS = "Suggestions";
    @NotNull
    public static final String CHAT = "Chat";
    @NotNull
    public static final String CONFIGURE = "Configure";
    @NotNull
    public static final String LEARN_MORE = "Learn More";

    /*
     * WARNING - void declaration
     */
    public OnboardingPanel(@NotNull ToolWindow toolWindow) {
        void $this$banner_u24lambda_u242_u24lambda_u241;
        void $this$banner_u24lambda_u242;
        Serializable serializable;
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super(new BorderLayout());
        Pair[] pairArray2 = pairArray = new BannerPanel();
        OnboardingPanel onboardingPanel = this;
        boolean bl = false;
        GridBagConstraints $this$banner_u24lambda_u242_u24lambda_u240 = serializable = new GridBagConstraints();
        boolean bl2 = false;
        $this$banner_u24lambda_u242_u24lambda_u240.gridx = -1;
        $this$banner_u24lambda_u242_u24lambda_u240.gridy = -1;
        $this$banner_u24lambda_u242_u24lambda_u240.weightx = 1.0;
        $this$banner_u24lambda_u242_u24lambda_u240.weighty = 1.0;
        $this$banner_u24lambda_u242_u24lambda_u240.fill = 2;
        $this$banner_u24lambda_u242_u24lambda_u240.anchor = 10;
        GridBagConstraints constraints = serializable;
        $this$banner_u24lambda_u242_u24lambda_u240 = serializable = new JLabel(CopilotIcons.CopilotOnboardingBanner);
        void var9_10 = $this$banner_u24lambda_u242;
        boolean bl3 = false;
        $this$banner_u24lambda_u242_u24lambda_u241.setOpaque(false);
        var9_10.add((Component)serializable, constraints);
        onboardingPanel.banner = pairArray;
        this.cardLayout = new CardLayout();
        pairArray = new Pair[5];
        String string = CopilotBundle.get("copilot.onboarding.welcome.next.button");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        pairArray[0] = TuplesKt.to((Object)WELCOME, (Object)new WelcomePage(new PageProgress(string, new ProgressAction((Function0<Unit>)((Function0)() -> OnboardingPanel.steps$lambda$3(this)))), null, 2, null));
        String string2 = CopilotBundle.get("copilot.onboarding.suggestions.next.button");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
        PageProgress pageProgress = new PageProgress(string2, new ProgressAction((Function0<Unit>)((Function0)() -> OnboardingPanel.steps$lambda$4(this))));
        String string3 = CopilotBundle.get("copilot.onboarding.suggestions.previous.button");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"get(...)");
        pairArray[1] = TuplesKt.to((Object)SUGGESTIONS, (Object)new SuggestionsPage(pageProgress, new PageProgress(string3, new ProgressAction((Function0<Unit>)((Function0)() -> OnboardingPanel.steps$lambda$5(this))))));
        String string4 = CopilotBundle.get("copilot.onboarding.chat.next.button");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"get(...)");
        PageProgress pageProgress2 = new PageProgress(string4, new ProgressAction((Function0<Unit>)((Function0)() -> OnboardingPanel.steps$lambda$6(this))));
        String string5 = CopilotBundle.get("copilot.onboarding.chat.previous.button");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"get(...)");
        pairArray[2] = TuplesKt.to((Object)CHAT, (Object)new ChatPage(pageProgress2, new PageProgress(string5, new ProgressAction((Function0<Unit>)((Function0)() -> OnboardingPanel.steps$lambda$7(this))))));
        String string6 = CopilotBundle.get("copilot.onboarding.configure.next.button");
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"get(...)");
        PageProgress pageProgress3 = new PageProgress(string6, new ProgressAction((Function0<Unit>)((Function0)() -> OnboardingPanel.steps$lambda$8(this))));
        String string7 = CopilotBundle.get("copilot.onboarding.configure.previous.button");
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"get(...)");
        pairArray[3] = TuplesKt.to((Object)CONFIGURE, (Object)new ConfigurePage(pageProgress3, new PageProgress(string7, new ProgressAction((Function0<Unit>)((Function0)() -> OnboardingPanel.steps$lambda$9(this))))));
        String string8 = CopilotBundle.get("copilot.onboarding.learn.more.next.button");
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"get(...)");
        PageProgress pageProgress4 = new PageProgress(string8, new ProgressAction((Function0<Unit>)((Function0)() -> OnboardingPanel.steps$lambda$10(this, toolWindow))));
        String string9 = CopilotBundle.get("copilot.onboarding.learn.more.previous.button");
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"get(...)");
        pairArray[4] = TuplesKt.to((Object)LEARN_MORE, (Object)new LearnMorePage(pageProgress4, new PageProgress(string9, new ProgressAction((Function0<Unit>)((Function0)() -> OnboardingPanel.steps$lambda$11(this))))));
        this.steps = MapsKt.mapOf((Pair[])pairArray);
        this.pageContent = new JPanel(this.cardLayout);
        this.setOpaque(false);
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic<CopilotFeatureFlagsListener> topic = CopilotFeatureFlagsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this);
        this.updateSteps();
        this.add((Component)this.banner, "North");
        this.add((Component)this.pageContent, "Center");
    }

    @NotNull
    public final BannerPanel getBanner() {
        return this.banner;
    }

    private final void updateSteps() {
        JPanel jPanel;
        JPanel $this$updateSteps_u24lambda_u2412 = jPanel = this.pageContent;
        boolean bl = false;
        $this$updateSteps_u24lambda_u2412.removeAll();
        for (Map.Entry<String, Page> step : this.steps.entrySet()) {
            $this$updateSteps_u24lambda_u2412.add((Component)step.getValue(), step.getKey());
        }
        this.showStep(WELCOME, false);
    }

    @Override
    public void onFeatureFlags(@NotNull CopilotFeatureFlags featureFlags) {
        Intrinsics.checkNotNullParameter((Object)featureFlags, (String)"featureFlags");
        this.updateSteps();
    }

    private final void showStep(String stepName, boolean requestFocus) {
        Page page = this.steps.get(stepName);
        if (page == null) {
            return;
        }
        Page page2 = page;
        ApplicationManager.getApplication().invokeLater(() -> OnboardingPanel.showStep$lambda$13(this, stepName, requestFocus, page2));
    }

    static /* synthetic */ void showStep$default(OnboardingPanel onboardingPanel, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        onboardingPanel.showStep(string, bl);
    }

    private static final Unit steps$lambda$3(OnboardingPanel this$0) {
        OnboardingPanel.showStep$default(this$0, SUGGESTIONS, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$4(OnboardingPanel this$0) {
        OnboardingPanel.showStep$default(this$0, CHAT, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$5(OnboardingPanel this$0) {
        OnboardingPanel.showStep$default(this$0, WELCOME, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$6(OnboardingPanel this$0) {
        OnboardingPanel.showStep$default(this$0, CONFIGURE, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$7(OnboardingPanel this$0) {
        OnboardingPanel.showStep$default(this$0, SUGGESTIONS, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$8(OnboardingPanel this$0) {
        OnboardingPanel.showStep$default(this$0, LEARN_MORE, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$9(OnboardingPanel this$0) {
        OnboardingPanel.showStep$default(this$0, CHAT, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$10(OnboardingPanel this$0, ToolWindow $toolWindow) {
        OnboardingPanel.showStep$default(this$0, WELCOME, false, 2, null);
        $toolWindow.hide();
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$11(OnboardingPanel this$0) {
        OnboardingPanel.showStep$default(this$0, CONFIGURE, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final void showStep$lambda$13(OnboardingPanel this$0, String $stepName, boolean $requestFocus, Page $page) {
        this$0.cardLayout.show(this$0.pageContent, $stepName);
        if ($requestFocus) {
            $page.getTitle().requestFocus();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/copilot/onboarding/OnboardingPanel$Companion;", "", "<init>", "()V", "WELCOME", "", "SUGGESTIONS", "CHAT", "CONFIGURE", "LEARN_MORE", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

