/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.platform.utils;

import com.github.copilot.lang.agent.lsp.VirtualFileUri;
import com.github.copilot.platform.utils.ApplicationKt;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\t\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e\u001a\u0011\u0010\u000f\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0010*\u00020\u0001\"\u001a\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\u0011"}, d2={"uri", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getUri", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "isIdeFile", "", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "isGitIgnored", "fileStatusManager", "Lcom/intellij/openapi/vcs/FileStatusManager;", "isIdeIgnored", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "toVirtualFileByUrl", "Lorg/jetbrains/annotations/Nullable;", "core"})
@SourceDebugExtension(value={"SMAP\nVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFile.kt\ncom/github/copilot/platform/utils/VirtualFileKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,29:1\n1747#2,3:30\n*S KotlinDebug\n*F\n+ 1 VirtualFile.kt\ncom/github/copilot/platform/utils/VirtualFileKt\n*L\n22#1:30,3\n*E\n"})
public final class VirtualFileKt {
    @NotNull
    public static final String getUri(@NotNull VirtualFile $this$uri) {
        Intrinsics.checkNotNullParameter((Object)$this$uri, (String)"<this>");
        String string = VirtualFileUri.from($this$uri).getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        return string;
    }

    public static final boolean isIdeFile(@NotNull VirtualFile $this$isIdeFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isIdeFile, (String)"<this>");
        return ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)$this$isIdeFile);
    }

    public static final boolean isGitIgnored(@NotNull VirtualFile $this$isGitIgnored, @NotNull FileStatusManager fileStatusManager) {
        Intrinsics.checkNotNullParameter((Object)$this$isGitIgnored, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileStatusManager, (String)"fileStatusManager");
        return Intrinsics.areEqual((Object)fileStatusManager.getStatus($this$isGitIgnored), (Object)FileStatus.IGNORED);
    }

    public static final boolean isIdeIgnored(@NotNull VirtualFile $this$isIdeIgnored, @NotNull ProjectFileIndex fileIndex) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isIdeIgnored, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)fileIndex, (String)"fileIndex");
            Object[] objectArray = new Function1[]{arg_0 -> VirtualFileKt.isIdeIgnored$lambda$1(fileIndex, arg_0), arg_0 -> VirtualFileKt.isIdeIgnored$lambda$3(fileIndex, arg_0)};
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Function1 isIgnoredCondition = (Function1)element$iv;
                    boolean bl2 = false;
                    if (!((Boolean)isIgnoredCondition.invoke((Object)$this$isIdeIgnored)).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final VirtualFile toVirtualFileByUrl(@NotNull String $this$toVirtualFileByUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toVirtualFileByUrl, (String)"<this>");
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(URLDecoder.decode($this$toVirtualFileByUrl, StandardCharsets.UTF_8));
        return virtualFile;
    }

    private static final boolean isIdeIgnored$lambda$1$lambda$0(ProjectFileIndex $fileIndex, VirtualFile $it) {
        return $fileIndex.isUnderIgnored($it);
    }

    private static final boolean isIdeIgnored$lambda$1(ProjectFileIndex $fileIndex, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)ApplicationKt.runReadAction(() -> VirtualFileKt.isIdeIgnored$lambda$1$lambda$0($fileIndex, it));
    }

    private static final boolean isIdeIgnored$lambda$3$lambda$2(ProjectFileIndex $fileIndex, VirtualFile $it) {
        return $fileIndex.isExcluded($it);
    }

    private static final boolean isIdeIgnored$lambda$3(ProjectFileIndex $fileIndex, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)ApplicationKt.runReadAction(() -> VirtualFileKt.isIdeIgnored$lambda$3$lambda$2($fileIndex, it));
    }
}

