/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.request;

import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class EditorRequestUtil {
    private EditorRequestUtil() {
    }

    public static List<String> fixIndentation(@NotNull List<String> lines, boolean useTabIndents, int tabWidth) {
        if (useTabIndents) {
            return lines.stream().map(line -> {
                int tabs = StringUtil.countChars((CharSequence)line, (char)' ', (int)0, (boolean)true) / tabWidth;
                int spaces = tabs * tabWidth;
                return StringUtil.repeatSymbol((char)'\t', (int)tabs) + line.substring(spaces);
            }).collect(Collectors.toList());
        }
        return lines.stream().map(line -> {
            int tabs = StringUtil.countChars((CharSequence)line, (char)'\t', (int)0, (boolean)true);
            int spaces = tabs * tabWidth;
            return StringUtil.repeatSymbol((char)' ', (int)spaces) + line.substring(tabs);
        }).collect(Collectors.toList());
    }
}

