/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.request;

import com.github.copilot.editor.CopilotEditorUtil;
import com.github.copilot.util.CopilotStringUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class LineInfo {
    private final int lineCount;
    private final int lineNumber;
    private final int lineStartOffset;
    private final int columnOffset;
    @NotNull
    private final String line;
    private final int nextLineIndent;

    @NotNull
    public static LineInfo create(@NotNull Document document, int offset) {
        int line = document.getLineNumber(offset);
        TextRange lineRange = TextRange.create((int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line));
        return new LineInfo(document.getLineCount(), line, lineRange.getStartOffset(), offset - lineRange.getStartOffset(), document.getText(lineRange), LineInfo.calculateNextLineIndent(document, offset));
    }

    @NotNull
    public String getLinePrefix() {
        return this.line.substring(0, this.columnOffset);
    }

    @NotNull
    public String getLineSuffix() {
        return this.line.substring(this.columnOffset);
    }

    public boolean isBlankLine() {
        return this.line.isBlank();
    }

    @NotNull
    public String getWhitespaceBeforeCursor() {
        return CopilotStringUtil.trailingWhitespace(this.getLinePrefix());
    }

    public int getLineEndOffset() {
        return this.getLineStartOffset() + this.line.length();
    }

    private static int calculateNextLineIndent(@NotNull Document document, int offset) {
        int maxLines = document.getLineCount();
        for (int line = document.getLineNumber(offset) + 1; line < maxLines; ++line) {
            String lineContent;
            int end;
            int start2 = document.getLineStartOffset(line);
            if (start2 == (end = document.getLineEndOffset(line)) || (lineContent = document.getText(TextRange.create((int)start2, (int)end))).isBlank()) continue;
            return CopilotEditorUtil.whitespacePrefixLength(lineContent);
        }
        return -1;
    }

    @Generated
    public LineInfo(int lineCount, int lineNumber, int lineStartOffset, int columnOffset, @NotNull String line, int nextLineIndent) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        this.lineCount = lineCount;
        this.lineNumber = lineNumber;
        this.lineStartOffset = lineStartOffset;
        this.columnOffset = columnOffset;
        this.line = line;
        this.nextLineIndent = nextLineIndent;
    }

    @Generated
    public int getLineCount() {
        return this.lineCount;
    }

    @Generated
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Generated
    public int getLineStartOffset() {
        return this.lineStartOffset;
    }

    @Generated
    public int getColumnOffset() {
        return this.columnOffset;
    }

    @NotNull
    @Generated
    public String getLine() {
        return this.line;
    }

    @Generated
    public int getNextLineIndent() {
        return this.nextLineIndent;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineInfo)) {
            return false;
        }
        LineInfo other = (LineInfo)o;
        if (this.getLineCount() != other.getLineCount()) {
            return false;
        }
        if (this.getLineNumber() != other.getLineNumber()) {
            return false;
        }
        if (this.getLineStartOffset() != other.getLineStartOffset()) {
            return false;
        }
        if (this.getColumnOffset() != other.getColumnOffset()) {
            return false;
        }
        if (this.getNextLineIndent() != other.getNextLineIndent()) {
            return false;
        }
        String this$line = this.getLine();
        String other$line = other.getLine();
        return !(this$line == null ? other$line != null : !this$line.equals(other$line));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLineCount();
        result = result * 59 + this.getLineNumber();
        result = result * 59 + this.getLineStartOffset();
        result = result * 59 + this.getColumnOffset();
        result = result * 59 + this.getNextLineIndent();
        String $line = this.getLine();
        result = result * 59 + ($line == null ? 43 : $line.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LineInfo(lineCount=" + this.getLineCount() + ", lineNumber=" + this.getLineNumber() + ", lineStartOffset=" + this.getLineStartOffset() + ", columnOffset=" + this.getColumnOffset() + ", line=" + this.getLine() + ", nextLineIndent=" + this.getNextLineIndent() + ")";
    }
}

