/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.settings;

import com.github.copilot.CopilotBundle;
import com.github.copilot.github.GitHubService;
import com.github.copilot.lang.agent.commands.EditorSettings;
import com.github.copilot.lsp.LSPManager;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.settings.CopilotApplicationState;
import com.github.copilot.settings.SettingsForm;
import com.github.copilot.settings.UpdateChannel;
import com.github.copilot.status.CopilotStatus;
import com.github.copilot.status.CopilotStatusService;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.NlsContexts;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationConfigurable
implements Configurable {
    private final SettingsForm form;

    public ApplicationConfigurable() {
        CopilotApplicationState applicationState = CopilotApplicationSettings.settings();
        this.form = new SettingsForm(applicationState.enableCompletions, applicationState.isShowIdeCompletions(), applicationState.inlayTextColor, applicationState.isScreenReaderEnabled(), this.findConfiguredChannel(), applicationState.checkForUpdate, applicationState.getLanguageAllowList(), applicationState.kerberosServicePrincipal, applicationState.authenticationProvider, applicationState.preferredAccount, applicationState.fetchStrategy, applicationState.chatNaturalLanguage, applicationState.inlineChatGutterIcon);
    }

    @NlsContexts.ConfigurableName
    public String getDisplayName() {
        return CopilotBundle.get("applicationConfigurable.displayName");
    }

    @Nullable
    public JComponent createComponent() {
        return this.form;
    }

    public void reset() {
        CopilotApplicationState applicationState = CopilotApplicationSettings.settings();
        this.form.setAutoShowCompletionsEnabled(applicationState.enableCompletions);
        this.form.setInlineGutterIconEnabled(applicationState.inlineChatGutterIcon);
        this.form.setShowIdeCompletionsSideBySideEnabled(applicationState.isShowIdeCompletions());
        this.form.setColorForCompletions(applicationState.inlayTextColor);
        this.form.setChannel(this.findConfiguredChannel());
        this.form.setCheckForPluginUpdatesEnabled(applicationState.checkForUpdate);
        this.form.setLanguageAllowList(applicationState.getLanguageAllowList());
        this.form.setKerberosServicePrincipal(applicationState.kerberosServicePrincipal);
        this.form.setAuthenticationProvider(applicationState.authenticationProvider);
        this.form.setPreferredAccount(applicationState.preferredAccount);
        this.form.setFetchStrategy(applicationState.fetchStrategy);
    }

    public boolean isModified() {
        CopilotApplicationState settings = CopilotApplicationSettings.settings();
        if (this.form.isAutoShowCompletionsEnabled() != settings.enableCompletions) {
            return true;
        }
        if (this.form.getInlineGutterIconEnabled() != settings.inlineChatGutterIcon) {
            return true;
        }
        if (!Objects.equals(this.form.getColorForCompletions(), settings.inlayTextColor)) {
            return true;
        }
        if (this.form.isCheckForPluginUpdatesEnabled() != settings.checkForUpdate) {
            return true;
        }
        if (this.form.isShowIdeCompletionsSideBySideEnabled() != settings.isShowIdeCompletions()) {
            return true;
        }
        if (this.form.isScreenReaderEnabled() != settings.isScreenReaderEnabled()) {
            return true;
        }
        if (!this.form.getChannel().equals((Object)this.findConfiguredChannel())) {
            return true;
        }
        if (!Objects.equals(this.form.getKerberosServicePrincipal(), settings.kerberosServicePrincipal)) {
            return true;
        }
        if (!Objects.equals(this.form.getAuthenticationProvider(), settings.authenticationProvider)) {
            return true;
        }
        if (!Objects.equals(this.form.getPreferredAccount(), settings.preferredAccount)) {
            return true;
        }
        if (!Objects.equals((Object)this.form.getFetchStrategy(), (Object)settings.fetchStrategy)) {
            return true;
        }
        if (!Objects.equals(this.form.getChatNaturalLanguage(), settings.chatNaturalLanguage)) {
            return true;
        }
        return !this.form.getLanguageAllowList().equals(settings.getLanguageAllowList());
    }

    public void apply() throws ConfigurationException {
        CopilotApplicationState settings = CopilotApplicationSettings.settings();
        boolean requiresSettingsNotification = this.requiresSettingsNotification(settings);
        settings.inlayTextColor = this.form.getColorForCompletions();
        settings.inlineChatGutterIcon = this.form.getInlineGutterIconEnabled();
        settings.setShowIdeCompletions(this.form.isShowIdeCompletionsSideBySideEnabled());
        settings.checkForUpdate = this.form.isCheckForPluginUpdatesEnabled();
        settings.enableCompletions = this.form.isAutoShowCompletionsEnabled();
        settings.enableScreenReader = this.form.isScreenReaderEnabled();
        settings.setLanguageAllowList(this.form.getLanguageAllowList());
        settings.kerberosServicePrincipal = this.form.getKerberosServicePrincipal();
        settings.authenticationProvider = this.form.getAuthenticationProvider();
        settings.preferredAccount = this.form.getPreferredAccount();
        settings.fetchStrategy = this.form.getFetchStrategy();
        settings.chatNaturalLanguage = this.form.getChatNaturalLanguage();
        this.applyChannelConfiguration();
        if (requiresSettingsNotification) {
            this.notifyAgentAboutSettingsChange(settings);
        }
    }

    private void notifyAgentAboutSettingsChange(CopilotApplicationState settings) {
        EditorSettings agentSettings = EditorSettings.basedOn(settings);
        LSPManager.getInstance().notifyConfigurationChanged(agentSettings);
        this.refreshCopilotStatus();
    }

    private void refreshCopilotStatus() {
        GitHubService service = GitHubService.getInstance();
        boolean wasSignedIn = service.isSignedIn();
        service.refreshStatus();
        if (wasSignedIn != service.isSignedIn()) {
            CopilotStatusService.notifyApplication(wasSignedIn ? CopilotStatus.NotSignedIn : CopilotStatus.Ready);
        }
    }

    private void applyChannelConfiguration() {
        UpdateChannel newChannel;
        UpdateChannel oldChannel = this.findConfiguredChannel();
        if (!oldChannel.equals((Object)(newChannel = this.form.getChannel()))) {
            if (!UpdateChannel.Stable.equals((Object)oldChannel)) {
                UpdateSettings.getInstance().getStoredPluginHosts().remove(oldChannel.getChannelUrl());
            }
            if (!UpdateChannel.Stable.equals((Object)newChannel)) {
                UpdateSettings.getInstance().getStoredPluginHosts().add(newChannel.getChannelUrl());
            }
        }
    }

    private boolean requiresSettingsNotification(CopilotApplicationState settings) {
        return this.form.isShowIdeCompletionsSideBySideEnabled() != settings.isShowIdeCompletions() || !this.form.getLanguageAllowList().equals(settings.getLanguageAllowList()) || this.form.isAutoShowCompletionsEnabled() != settings.enableCompletions || !this.form.getAuthenticationProvider().equals(settings.authenticationProvider) || !Objects.equals((Object)this.form.getFetchStrategy(), (Object)settings.fetchStrategy) || !Objects.equals(this.form.getPreferredAccount(), settings.preferredAccount);
    }

    @NotNull
    private UpdateChannel findConfiguredChannel() {
        UpdateChannel currentChannel = UpdateChannel.Stable;
        for (UpdateChannel channel : UpdateChannel.values()) {
            String url = channel.getChannelUrl();
            if (url == null || !UpdateSettings.getInstance().getStoredPluginHosts().contains(url)) continue;
            currentChannel = channel;
            break;
        }
        return currentChannel;
    }

    SettingsForm getForm() {
        return this.form;
    }
}

