/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.settings;

import com.github.copilot.settings.CopilotApplicationState;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="github-copilot", storages={@Storage(value="github-copilot.xml")})
public class CopilotApplicationSettings
implements PersistentStateComponent<CopilotApplicationState> {
    private CopilotApplicationState state;

    @NotNull
    public static CopilotApplicationState settings() {
        CopilotApplicationState state = ((CopilotApplicationSettings)ApplicationManager.getApplication().getService(CopilotApplicationSettings.class)).getState();
        assert (state != null);
        return state;
    }

    public static boolean isCopilotEnabled(@NotNull Project project, @NotNull Editor editor) {
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        return file != null && CopilotApplicationSettings.isCopilotEnabled(file);
    }

    public static boolean isCopilotEnabled(@NotNull PsiFile file) {
        Language language = file.getLanguage();
        return CopilotApplicationSettings.isCopilotEnabled(language);
    }

    public static boolean isCopilotEnabled(@NotNull Language language) {
        CopilotApplicationState settings = CopilotApplicationSettings.settings();
        return settings.enableCompletions && settings.isEnabled(language);
    }

    @Nullable
    public synchronized CopilotApplicationState getState() {
        return this.state;
    }

    public synchronized void noStateLoaded() {
        this.state = new CopilotApplicationState();
    }

    public synchronized void loadState(@NotNull CopilotApplicationState state) {
        this.state = state;
    }
}

