/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.settings;

import com.github.copilot.lang.agent.commands.FetchStrategy;
import com.github.copilot.settings.ColorConverter;
import com.github.copilot.settings.CopilotChatLocale;
import com.github.copilot.settings.language.LanguageAllowList;
import com.intellij.lang.Language;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class CopilotApplicationState {
    @OptionTag(value="signinNotificationShown")
    public boolean signinNotificationShown = false;
    @OptionTag(value="enableCompletions")
    public boolean enableCompletions = true;
    @OptionTag(value="inlineChatGutterIcon")
    public boolean inlineChatGutterIcon = true;
    @XCollection(style=XCollection.Style.v2, propertyElementName="disabledLanguages", elementTypes={String.class})
    private final Set<String> disabledLanguageIds = new HashSet<String>();
    @XCollection(style=XCollection.Style.v2, propertyElementName="languageAllowList", elementTypes={String.class, Boolean.class})
    private final Map<String, Boolean> languageAllowList = new HashMap<String, Boolean>();
    @OptionTag(value="languageAllowListReadOnly")
    public boolean isLanguageAllowListReadOnly = false;
    @Nullable
    @OptionTag(value="inlayTextColor", converter=ColorConverter.class)
    public Color inlayTextColor = null;
    @OptionTag(value="showIdeCompletions")
    private boolean showIdeCompletions = false;
    @OptionTag(value="enableScreenReader")
    public boolean enableScreenReader = false;
    @OptionTag(value="checkForUpdate")
    public boolean checkForUpdate = true;
    @OptionTag(value="kerberosServicePrincipal")
    public String kerberosServicePrincipal = "";
    @OptionTag(value="authenticationProvider")
    public String authenticationProvider = "";
    @OptionTag(value="preferredAccount")
    public String preferredAccount = "";
    @OptionTag(value="fetchStrategy")
    public FetchStrategy fetchStrategy = FetchStrategy.Auto;
    @OptionTag(value="chatNaturalLanguage")
    public String chatNaturalLanguage = CopilotChatLocale.INSTANCE.getLocaleByLanguageName(Locale.getDefault().getLanguage()).getDisplayName();

    public boolean isShowIdeCompletions() {
        return this.showIdeCompletions;
    }

    public void setShowIdeCompletions(boolean showIdeCompletions) {
        if (this.showIdeCompletions != showIdeCompletions) {
            this.showIdeCompletions = showIdeCompletions;
        }
    }

    public boolean isScreenReaderEnabled() {
        return this.enableScreenReader;
    }

    public void setScreenReaderEnabled(boolean enableScreenReader) {
        if (this.enableScreenReader != enableScreenReader) {
            this.enableScreenReader = enableScreenReader;
        }
    }

    @NotNull
    public LanguageAllowList getLanguageAllowList() {
        this.disabledLanguageIds.forEach(disabledLanguageId -> this.languageAllowList.put((String)disabledLanguageId, false));
        this.disabledLanguageIds.clear();
        return new LanguageAllowList(this.isLanguageAllowListReadOnly, this.languageAllowList);
    }

    public void setLanguageAllowList(@NotNull LanguageAllowList allowList) {
        this.languageAllowList.clear();
        this.languageAllowList.putAll(allowList.asMap());
    }

    public boolean isEnabled(@NotNull Language language) {
        return this.getLanguageAllowList().isEnabled(language.getID());
    }

    public void enableLanguage(@NotNull Language language) {
        this.setLanguageAllowList(this.getLanguageAllowList().enableLanguage(language.getID()));
    }

    public void disableLanguage(@NotNull Language language) {
        this.setLanguageAllowList(this.getLanguageAllowList().disableLanguage(language.getID()));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopilotApplicationState)) {
            return false;
        }
        CopilotApplicationState other = (CopilotApplicationState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.signinNotificationShown != other.signinNotificationShown) {
            return false;
        }
        if (this.enableCompletions != other.enableCompletions) {
            return false;
        }
        if (this.inlineChatGutterIcon != other.inlineChatGutterIcon) {
            return false;
        }
        if (this.isLanguageAllowListReadOnly != other.isLanguageAllowListReadOnly) {
            return false;
        }
        if (this.isShowIdeCompletions() != other.isShowIdeCompletions()) {
            return false;
        }
        if (this.enableScreenReader != other.enableScreenReader) {
            return false;
        }
        if (this.checkForUpdate != other.checkForUpdate) {
            return false;
        }
        Set<String> this$disabledLanguageIds = this.disabledLanguageIds;
        Set<String> other$disabledLanguageIds = other.disabledLanguageIds;
        if (this$disabledLanguageIds == null ? other$disabledLanguageIds != null : !((Object)this$disabledLanguageIds).equals(other$disabledLanguageIds)) {
            return false;
        }
        LanguageAllowList this$languageAllowList = this.getLanguageAllowList();
        LanguageAllowList other$languageAllowList = other.getLanguageAllowList();
        if (this$languageAllowList == null ? other$languageAllowList != null : !((Object)this$languageAllowList).equals(other$languageAllowList)) {
            return false;
        }
        Color this$inlayTextColor = this.inlayTextColor;
        Color other$inlayTextColor = other.inlayTextColor;
        if (this$inlayTextColor == null ? other$inlayTextColor != null : !((Object)this$inlayTextColor).equals(other$inlayTextColor)) {
            return false;
        }
        String this$kerberosServicePrincipal = this.kerberosServicePrincipal;
        String other$kerberosServicePrincipal = other.kerberosServicePrincipal;
        if (this$kerberosServicePrincipal == null ? other$kerberosServicePrincipal != null : !this$kerberosServicePrincipal.equals(other$kerberosServicePrincipal)) {
            return false;
        }
        String this$authenticationProvider = this.authenticationProvider;
        String other$authenticationProvider = other.authenticationProvider;
        if (this$authenticationProvider == null ? other$authenticationProvider != null : !this$authenticationProvider.equals(other$authenticationProvider)) {
            return false;
        }
        String this$preferredAccount = this.preferredAccount;
        String other$preferredAccount = other.preferredAccount;
        if (this$preferredAccount == null ? other$preferredAccount != null : !this$preferredAccount.equals(other$preferredAccount)) {
            return false;
        }
        FetchStrategy this$fetchStrategy = this.fetchStrategy;
        FetchStrategy other$fetchStrategy = other.fetchStrategy;
        if (this$fetchStrategy == null ? other$fetchStrategy != null : !((Object)((Object)this$fetchStrategy)).equals((Object)other$fetchStrategy)) {
            return false;
        }
        String this$chatNaturalLanguage = this.chatNaturalLanguage;
        String other$chatNaturalLanguage = other.chatNaturalLanguage;
        return !(this$chatNaturalLanguage == null ? other$chatNaturalLanguage != null : !this$chatNaturalLanguage.equals(other$chatNaturalLanguage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CopilotApplicationState;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.signinNotificationShown ? 79 : 97);
        result = result * 59 + (this.enableCompletions ? 79 : 97);
        result = result * 59 + (this.inlineChatGutterIcon ? 79 : 97);
        result = result * 59 + (this.isLanguageAllowListReadOnly ? 79 : 97);
        result = result * 59 + (this.isShowIdeCompletions() ? 79 : 97);
        result = result * 59 + (this.enableScreenReader ? 79 : 97);
        result = result * 59 + (this.checkForUpdate ? 79 : 97);
        Set<String> $disabledLanguageIds = this.disabledLanguageIds;
        result = result * 59 + ($disabledLanguageIds == null ? 43 : ((Object)$disabledLanguageIds).hashCode());
        LanguageAllowList $languageAllowList = this.getLanguageAllowList();
        result = result * 59 + ($languageAllowList == null ? 43 : ((Object)$languageAllowList).hashCode());
        Color $inlayTextColor = this.inlayTextColor;
        result = result * 59 + ($inlayTextColor == null ? 43 : ((Object)$inlayTextColor).hashCode());
        String $kerberosServicePrincipal = this.kerberosServicePrincipal;
        result = result * 59 + ($kerberosServicePrincipal == null ? 43 : $kerberosServicePrincipal.hashCode());
        String $authenticationProvider = this.authenticationProvider;
        result = result * 59 + ($authenticationProvider == null ? 43 : $authenticationProvider.hashCode());
        String $preferredAccount = this.preferredAccount;
        result = result * 59 + ($preferredAccount == null ? 43 : $preferredAccount.hashCode());
        FetchStrategy $fetchStrategy = this.fetchStrategy;
        result = result * 59 + ($fetchStrategy == null ? 43 : ((Object)((Object)$fetchStrategy)).hashCode());
        String $chatNaturalLanguage = this.chatNaturalLanguage;
        result = result * 59 + ($chatNaturalLanguage == null ? 43 : $chatNaturalLanguage.hashCode());
        return result;
    }
}

