/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.settings.language;

import com.github.copilot.settings.language.Language;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!BT\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u0012)\b\u0002\u0010\u0007\u001a#\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0006J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\u0016\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0000J\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0013\u0010\u001f\u001a\u00020\u00032\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0010R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/github/copilot/settings/language/LanguageAllowList;", "", "isReadOnly", "", "allowList", "", "", "getLanguages", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "isAllowedDefault", "", "Lcom/github/copilot/settings/language/Language;", "<init>", "(ZLjava/util/Map;Lkotlin/jvm/functions/Function1;)V", "()Z", "languages", "()Ljava/util/List;", "isEnabled", "languageId", "enableLanguage", "disableLanguage", "getDisabledLanguageIds", "updateLanguage", "id", "isAllowed", "updateLanguages", "asMap", "hashCode", "", "equals", "other", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLanguageAllowList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageAllowList.kt\ncom/github/copilot/settings/language/LanguageAllowList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n766#2:91\n857#2,2:92\n1045#2:94\n2634#2:95\n766#2:98\n857#2,2:99\n1549#2:101\n1620#2,3:102\n1855#2,2:105\n1855#2,2:107\n1855#2,2:109\n1#3:96\n1#3:97\n*S KotlinDebug\n*F\n+ 1 LanguageAllowList.kt\ncom/github/copilot/settings/language/LanguageAllowList\n*L\n17#1:91\n17#1:92,2\n18#1:94\n19#1:95\n28#1:98\n28#1:99,2\n29#1:101\n29#1:102,3\n32#1:105,2\n40#1:107,2\n44#1:109,2\n19#1:96\n*E\n"})
public final class LanguageAllowList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isReadOnly;
    private final boolean isAllowedDefault;
    @NotNull
    private final List<Language> languages;
    @NotNull
    public static final String ALL_LANGUAGES_WILDCARD = "*";

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public LanguageAllowList(boolean isReadOnly, @NotNull Map<String, Boolean> allowList, @NotNull Function1<? super Boolean, ? extends List<Language>> getLanguages) {
        void $this$onEach$iv;
        Iterable $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(allowList, (String)"allowList");
        Intrinsics.checkNotNullParameter(getLanguages, (String)"getLanguages");
        this.isReadOnly = isReadOnly;
        Boolean bl = allowList.get(ALL_LANGUAGES_WILDCARD);
        this.isAllowedDefault = bl != null ? bl : true;
        Iterable iterable = (Iterable)getLanguages.invoke((Object)this.isAllowedDefault);
        LanguageAllowList languageAllowList = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Language it = (Language)element$iv$iv;
            boolean bl2 = false;
            boolean bl3 = !StringsKt.isBlank((CharSequence)it.getName());
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Language it = (Language)a;
                boolean bl = false;
                String string = it.getName();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
                it = (Language)b;
                Comparable comparable = (Comparable)((Object)string2);
                bl = false;
                string = it.getName();
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                String string3 = string.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string3)));
            }
        });
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2416$iv = var6_7 = $this$onEach$iv;
        boolean bl4 = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            Language language = (Language)element$iv;
            boolean bl5 = false;
            Boolean bl6 = allowList.get(language.getId());
            if (bl6 == null) continue;
            boolean isAllowed = bl6;
            boolean bl7 = false;
            language.setAllowed(isAllowed);
        }
        languageAllowList.languages = (List)var6_7;
    }

    public /* synthetic */ LanguageAllowList(boolean bl, Map map, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 4) != 0) {
            function1 = (Function1)new Function1<Boolean, List<? extends Language>>((Object)Companion){

                public final List<Language> invoke(boolean p0) {
                    return ((Companion)this.receiver).getRegisteredLanguages(p0);
                }
            };
        }
        this(bl, map, (Function1<? super Boolean, ? extends List<Language>>)function1);
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    @NotNull
    public final List<Language> getLanguages() {
        return this.languages;
    }

    public final boolean isEnabled(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        return !this.getDisabledLanguageIds().contains(languageId);
    }

    @NotNull
    public final LanguageAllowList enableLanguage(@NotNull String languageId) {
        LanguageAllowList languageAllowList;
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        LanguageAllowList $this$enableLanguage_u24lambda_u244 = languageAllowList = this;
        boolean bl = false;
        $this$enableLanguage_u24lambda_u244.updateLanguage(languageId, true);
        return languageAllowList;
    }

    @NotNull
    public final LanguageAllowList disableLanguage(@NotNull String languageId) {
        LanguageAllowList languageAllowList;
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        LanguageAllowList $this$disableLanguage_u24lambda_u245 = languageAllowList = this;
        boolean bl = false;
        $this$disableLanguage_u24lambda_u245.updateLanguage(languageId, false);
        return languageAllowList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getDisabledLanguageIds() {
        void $this$mapTo$iv$iv;
        Language it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.languages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Language)element$iv$iv;
            boolean bl = false;
            if (!(!it.isAllowed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Language)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final LanguageAllowList updateLanguage(@NotNull String id, boolean isAllowed) {
        LanguageAllowList languageAllowList;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        LanguageAllowList $this$updateLanguage_u24lambda_u249 = languageAllowList = this;
        boolean bl = false;
        Iterable $this$forEach$iv = $this$updateLanguage_u24lambda_u249.languages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Language language = (Language)element$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)language.getId(), (Object)id)) continue;
            language.setAllowed(isAllowed);
        }
        return languageAllowList;
    }

    @NotNull
    public final LanguageAllowList updateLanguages(@NotNull LanguageAllowList allowList) {
        LanguageAllowList languageAllowList;
        Intrinsics.checkNotNullParameter((Object)allowList, (String)"allowList");
        LanguageAllowList $this$updateLanguages_u24lambda_u2411 = languageAllowList = this;
        boolean bl = false;
        Iterable $this$forEach$iv = allowList.languages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Language it = (Language)element$iv;
            boolean bl2 = false;
            $this$updateLanguages_u24lambda_u2411.updateLanguage(it.getId(), it.isAllowed());
        }
        return languageAllowList;
    }

    @NotNull
    public final Map<String, Boolean> asMap() {
        Object object = new Pair[]{TuplesKt.to((Object)ALL_LANGUAGES_WILDCARD, (Object)this.isAllowedDefault)};
        Object $this$asMap_u24lambda_u2413 = object = MapsKt.mutableMapOf((Pair[])object);
        boolean bl = false;
        Iterable $this$forEach$iv = this.languages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Language language = (Language)element$iv;
            boolean bl2 = false;
            if (language.isAllowed() == this.isAllowedDefault) continue;
            $this$asMap_u24lambda_u2413.put(language.getId(), language.isAllowed());
        }
        return object;
    }

    public int hashCode() {
        return ((Object)this.asMap()).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof LanguageAllowList)) {
            return false;
        }
        Map<String, Boolean> thisAsMap = this.asMap();
        Map<String, Boolean> otherAsMap = ((LanguageAllowList)other).asMap();
        if (thisAsMap.size() != otherAsMap.size()) {
            return false;
        }
        for (Map.Entry<String, Boolean> entry : otherAsMap.entrySet()) {
            String otherKey = entry.getKey();
            boolean otherVal = entry.getValue();
            Boolean bl = thisAsMap.get(otherKey);
            if (bl == null) {
                return false;
            }
            boolean thisVal = bl;
            if (thisVal == otherVal) continue;
            return false;
        }
        return true;
    }

    @JvmOverloads
    public LanguageAllowList(boolean isReadOnly, @NotNull Map<String, Boolean> allowList) {
        Intrinsics.checkNotNullParameter(allowList, (String)"allowList");
        this(isReadOnly, allowList, null, 4, null);
    }

    @JvmOverloads
    public LanguageAllowList(boolean isReadOnly) {
        this(isReadOnly, null, null, 6, null);
    }

    @JvmOverloads
    public LanguageAllowList() {
        this(false, null, null, 7, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\f0\u0005\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r*\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/github/copilot/settings/language/LanguageAllowList$Companion;", "", "<init>", "()V", "ALL_LANGUAGES_WILDCARD", "", "getRegisteredLanguages", "", "Lcom/github/copilot/settings/language/Language;", "isAllowedDefault", "", "getName", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/lang/Language;", "core"})
    @SourceDebugExtension(value={"SMAP\nLanguageAllowList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageAllowList.kt\ncom/github/copilot/settings/language/LanguageAllowList$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1549#2:91\n1620#2,3:92\n1#3:95\n*S KotlinDebug\n*F\n+ 1 LanguageAllowList.kt\ncom/github/copilot/settings/language/LanguageAllowList$Companion\n*L\n81#1:91\n81#1:92,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<Language> getRegisteredLanguages(boolean isAllowedDefault) {
            void $this$mapTo$iv$iv;
            Collection collection = com.intellij.lang.Language.getRegisteredLanguages();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredLanguages(...)");
            Iterable $this$map$iv = CollectionsKt.toMutableList((Collection)collection);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                com.intellij.lang.Language language = (com.intellij.lang.Language)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                String string = it.getID();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
                Intrinsics.checkNotNull((Object)it);
                collection2.add(new Language(string, Companion.getName((com.intellij.lang.Language)it), isAllowedDefault));
            }
            return (List)destination$iv$iv;
        }

        static /* synthetic */ List getRegisteredLanguages$default(Companion companion, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            return companion.getRegisteredLanguages(bl);
        }

        private final String getName(com.intellij.lang.Language $this$getName) {
            CharSequence charSequence;
            try {
                CharSequence charSequence2;
                charSequence = $this$getName.getDisplayName();
                if (StringsKt.isBlank((CharSequence)charSequence)) {
                    boolean bl = false;
                    charSequence2 = $this$getName.getID();
                } else {
                    charSequence2 = charSequence;
                }
                charSequence = (String)charSequence2;
            }
            catch (Exception exception) {
                charSequence = $this$getName.getID();
            }
            CharSequence charSequence3 = charSequence;
            Intrinsics.checkNotNull((Object)charSequence3);
            return charSequence3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

