/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.status;

import com.github.copilot.chat.user.GitHubUser;
import com.github.copilot.github.GitHubService;
import com.github.copilot.lang.agent.AgentGitHubService;
import com.github.copilot.lang.agent.commands.AuthStatusResult;
import com.github.copilot.platform.utils.ApplicationKt;
import com.github.copilot.status.CopilotAuthStatus;
import com.github.copilot.status.CopilotStatus;
import com.github.copilot.status.CopilotStatusListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u001a\u001a\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000b\u001a\u001a\u0010\r\u001a\u00020\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\t0\u000b\u001a\u0016\u0010\u0018\u001a\u00020\u0011*\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005\u001a\u000e\u0010\u001a\u001a\u00020\f*\u0004\u0018\u00010\u0005H\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\"\u0015\u0010\u0013\u001a\u00020\u0011*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012\"\u0015\u0010\u0014\u001a\u00020\u0011*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\"\u0015\u0010\u0015\u001a\u00020\u0011*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012\"\u0015\u0010\u0016\u001a\u00020\u0011*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012\"\u0015\u0010\u0017\u001a\u00020\u0011*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006\u001b"}, d2={"agentGitHubService", "Lcom/github/copilot/lang/agent/AgentGitHubService;", "getAgentGitHubService", "()Lcom/github/copilot/lang/agent/AgentGitHubService;", "currentStatus", "Lcom/github/copilot/lang/agent/commands/AuthStatusResult;", "getCurrentStatus", "()Lcom/github/copilot/lang/agent/commands/AuthStatusResult;", "subscribeToCopilotAuthStatus", "", "onStatus", "Lkotlin/Function1;", "Lcom/github/copilot/status/CopilotAuthStatus;", "onCopilotReady", "onReady", "Lcom/github/copilot/chat/user/GitHubUser;", "isReady", "", "(Lcom/github/copilot/status/CopilotAuthStatus;)Z", "isNotSignedIn", "isTokenInvalid", "isNotAuthorized", "isFailedToGetToken", "isUnknown", "hasChanged", "other", "toCopilotStatus", "core"})
@SourceDebugExtension(value={"SMAP\nCopilotAuthStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopilotAuthStatus.kt\ncom/github/copilot/status/CopilotAuthStatusKt\n+ 2 Service.kt\ncom/github/copilot/platform/utils/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n5#2,4:118\n1#3:122\n*S KotlinDebug\n*F\n+ 1 CopilotAuthStatus.kt\ncom/github/copilot/status/CopilotAuthStatusKt\n*L\n13#1:118,4\n*E\n"})
public final class CopilotAuthStatusKt {
    private static final AgentGitHubService getAgentGitHubService() {
        boolean $i$f$platformService = false;
        Class<GitHubService> service$iv = GitHubService.class;
        boolean bl = false;
        Object object = ApplicationManager.getApplication().getService(service$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + service$iv.getName() + " (classloader: " + service$iv.getClassLoader());
        }
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.github.copilot.lang.agent.AgentGitHubService");
        return (AgentGitHubService)object;
    }

    private static final AuthStatusResult getCurrentStatus() {
        AuthStatusResult authStatusResult;
        try {
            authStatusResult = CopilotAuthStatusKt.getAgentGitHubService().getStatus();
        }
        catch (Throwable throwable) {
            authStatusResult = null;
        }
        return authStatusResult;
    }

    public static final void subscribeToCopilotAuthStatus(@NotNull Function1<? super CopilotAuthStatus, Unit> onStatus) {
        Intrinsics.checkNotNullParameter(onStatus, (String)"onStatus");
        Ref.ObjectRef lastStatus = new Ref.ObjectRef();
        lastStatus.element = CopilotAuthStatusKt.getCurrentStatus();
        Ref.BooleanRef hasSignedIn = new Ref.BooleanRef();
        onStatus.invoke((Object)CopilotAuthStatusKt.toCopilotStatus((AuthStatusResult)lastStatus.element));
        Application application = ApplicationKt.application();
        Topic<CopilotStatusListener> topic = CopilotStatusListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ApplicationKt.subscribe(application, topic, (arg_0, arg_1) -> CopilotAuthStatusKt.subscribeToCopilotAuthStatus$lambda$0(hasSignedIn, lastStatus, onStatus, arg_0, arg_1));
    }

    public static final void onCopilotReady(@NotNull Function1<? super GitHubUser, Unit> onReady) {
        Intrinsics.checkNotNullParameter(onReady, (String)"onReady");
        CopilotAuthStatusKt.subscribeToCopilotAuthStatus((Function1<? super CopilotAuthStatus, Unit>)((Function1)arg_0 -> CopilotAuthStatusKt.onCopilotReady$lambda$1(onReady, arg_0)));
    }

    public static final boolean isReady(@NotNull CopilotAuthStatus $this$isReady) {
        Intrinsics.checkNotNullParameter((Object)$this$isReady, (String)"<this>");
        return $this$isReady instanceof CopilotAuthStatus.Ready;
    }

    public static final boolean isNotSignedIn(@NotNull CopilotAuthStatus $this$isNotSignedIn) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotSignedIn, (String)"<this>");
        return $this$isNotSignedIn instanceof CopilotAuthStatus.NotSignedIn;
    }

    public static final boolean isTokenInvalid(@NotNull CopilotAuthStatus $this$isTokenInvalid) {
        Intrinsics.checkNotNullParameter((Object)$this$isTokenInvalid, (String)"<this>");
        return $this$isTokenInvalid instanceof CopilotAuthStatus.TokenInvalid;
    }

    public static final boolean isNotAuthorized(@NotNull CopilotAuthStatus $this$isNotAuthorized) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotAuthorized, (String)"<this>");
        return $this$isNotAuthorized instanceof CopilotAuthStatus.NotAuthorized;
    }

    public static final boolean isFailedToGetToken(@NotNull CopilotAuthStatus $this$isFailedToGetToken) {
        Intrinsics.checkNotNullParameter((Object)$this$isFailedToGetToken, (String)"<this>");
        return $this$isFailedToGetToken instanceof CopilotAuthStatus.FailedToGetToken;
    }

    public static final boolean isUnknown(@NotNull CopilotAuthStatus $this$isUnknown) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnknown, (String)"<this>");
        return $this$isUnknown instanceof CopilotAuthStatus.Unknown;
    }

    public static final boolean hasChanged(@Nullable AuthStatusResult $this$hasChanged, @Nullable AuthStatusResult other) {
        if ($this$hasChanged == null && other == null) {
            return false;
        }
        if ($this$hasChanged != null && other == null || $this$hasChanged == null && other != null) {
            return true;
        }
        Intrinsics.checkNotNull((Object)$this$hasChanged, (String)"null cannot be cast to non-null type com.github.copilot.lang.agent.commands.AuthStatusResult");
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.github.copilot.lang.agent.commands.AuthStatusResult");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$hasChanged.status.ordinal()]) {
            case 1 -> {
                if (!(other.status == AuthStatusResult.Status.Ok && other.status == AuthStatusResult.Status.MaybeOk || Intrinsics.areEqual((Object)$this$hasChanged.user, (Object)other.user))) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (!(other.status == AuthStatusResult.Status.MaybeOk && other.status == AuthStatusResult.Status.Ok || Intrinsics.areEqual((Object)$this$hasChanged.user, (Object)other.user))) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (other.status != AuthStatusResult.Status.NotSignedIn) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (other.status != AuthStatusResult.Status.NotAuthorized) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (other.status != AuthStatusResult.Status.FailedToGetToken) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                if (other.status != AuthStatusResult.Status.TokenInvalid) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final CopilotAuthStatus toCopilotStatus(AuthStatusResult $this$toCopilotStatus) {
        if ($this$toCopilotStatus == null) {
            return CopilotAuthStatus.Unknown.INSTANCE;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toCopilotStatus.status.ordinal()]) {
            case 1, 2 -> {
                String v0 = $this$toCopilotStatus.user;
                if (v0 != null) {
                    String it = v0;
                    boolean $i$a$-let-CopilotAuthStatusKt$toCopilotStatus$1 = false;
                    yield new CopilotAuthStatus.Ready(new GitHubUser(it, null, 2, null));
                }
                yield CopilotAuthStatus.NotSignedIn.INSTANCE;
            }
            case 3 -> CopilotAuthStatus.NotSignedIn.INSTANCE;
            case 4 -> CopilotAuthStatus.NotAuthorized.INSTANCE;
            case 5 -> CopilotAuthStatus.FailedToGetToken.INSTANCE;
            case 6 -> CopilotAuthStatus.TokenInvalid.INSTANCE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final void subscribeToCopilotAuthStatus$lambda$0(Ref.BooleanRef $hasSignedIn, Ref.ObjectRef $lastStatus, Function1 $onStatus, CopilotStatus copilotStatus, String string) {
        Intrinsics.checkNotNullParameter((Object)((Object)copilotStatus), (String)"<unused var>");
        AuthStatusResult status = CopilotAuthStatusKt.getCurrentStatus();
        if ($hasSignedIn.element && status == null) {
            status = new AuthStatusResult(AuthStatusResult.Status.NotSignedIn, null, null);
        }
        AuthStatusResult authStatusResult = status;
        if ((authStatusResult != null ? authStatusResult.status : null) == AuthStatusResult.Status.Ok) {
            $hasSignedIn.element = true;
        }
        if (CopilotAuthStatusKt.hasChanged((AuthStatusResult)$lastStatus.element, status)) {
            $lastStatus.element = status;
            $onStatus.invoke((Object)CopilotAuthStatusKt.toCopilotStatus(status));
        }
    }

    private static final Unit onCopilotReady$lambda$1(Function1 $onReady, CopilotAuthStatus status) {
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        if (status instanceof CopilotAuthStatus.Ready) {
            $onReady.invoke((Object)((CopilotAuthStatus.Ready)status).getUser());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AuthStatusResult.Status.values().length];
            try {
                nArray[AuthStatusResult.Status.Ok.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthStatusResult.Status.MaybeOk.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthStatusResult.Status.NotSignedIn.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthStatusResult.Status.NotAuthorized.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthStatusResult.Status.FailedToGetToken.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthStatusResult.Status.TokenInvalid.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

