/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.status;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotIcons;
import com.intellij.util.ui.PresentableEnum;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public enum CopilotStatus implements PresentableEnum
{
    Ready,
    NotSignedIn,
    NotAuthorized,
    CompletionInProgress,
    AgentWarning,
    AgentError,
    AgentBroken,
    IncompatibleClient,
    Unsupported,
    UnknownError,
    Inactive;


    public boolean isDisablingClientRequests() {
        return this == IncompatibleClient || this == AgentBroken;
    }

    @NotNull
    public Icon getIcon() {
        switch (this) {
            case Ready: {
                return CopilotIcons.COPILOT;
            }
            case CompletionInProgress: {
                return CopilotIcons.StatusBarCompletionInProgress;
            }
            case AgentWarning: {
                return CopilotIcons.CopilotWarning;
            }
            case AgentError: 
            case AgentBroken: 
            case IncompatibleClient: 
            case Unsupported: 
            case UnknownError: {
                return CopilotIcons.CopilotNotAvailable;
            }
        }
        return CopilotIcons.CopilotDisconnected;
    }

    public String getPresentableText() {
        switch (this) {
            case Ready: {
                return CopilotBundle.get("copilotStatus.ready");
            }
            case NotSignedIn: {
                return CopilotBundle.get("copilotStatus.notSignedIn");
            }
            case NotAuthorized: {
                return CopilotBundle.get("copilotStatus.notAuthorized");
            }
            case CompletionInProgress: {
                return CopilotBundle.get("copilotStatus.completionInProgress");
            }
            case AgentWarning: {
                return CopilotBundle.get("copilotStatus.agentWarning");
            }
            case AgentError: {
                return CopilotBundle.get("copilotStatus.agentError");
            }
            case AgentBroken: {
                return CopilotBundle.get("copilotStatus.agentBroken");
            }
            case Inactive: {
                return CopilotBundle.get("copilotStatus.agentInactive");
            }
            case IncompatibleClient: {
                return CopilotBundle.get("copilotStatus.incompatibleClient");
            }
            case Unsupported: {
                return CopilotBundle.get("copilotStatus.unsupported");
            }
            case UnknownError: {
                return CopilotBundle.get("copilotStatus.unknownError");
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this));
    }
}

