/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.status;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotNotifications;
import com.github.copilot.status.CopilotStatus;
import com.github.copilot.status.CopilotStatusListener;
import com.github.copilot.statusBar.CopilotStatusBarWidget;
import com.github.copilot.update.CopilotPluginUpdater;
import com.github.copilot.util.ApplicationUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopilotStatusService
implements CopilotStatusListener,
Disposable {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    @NotNull
    private CopilotStatus status = CopilotStatus.NotSignedIn;
    @GuardedBy(value="lock")
    @Nullable
    private String message;
    private static final AtomicBoolean clientRequestsDisabled = new AtomicBoolean();

    public static boolean isClientRequestsDisabled() {
        return clientRequestsDisabled.get();
    }

    @NotNull
    public static Pair<CopilotStatus, String> getCurrentStatus() {
        return ((CopilotStatusService)ApplicationManager.getApplication().getService(CopilotStatusService.class)).getStatus();
    }

    public CopilotStatusService() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(CopilotStatusListener.TOPIC, (Object)this);
    }

    public static void notifyApplication(@NotNull CopilotStatus status) {
        CopilotStatusService.notifyApplication(status, null);
    }

    public static void notifyApplication(@NotNull CopilotStatus status, @Nullable String customMessage) {
        ((CopilotStatusListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(CopilotStatusListener.TOPIC)).onCopilotStatus(status, customMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCopilotStatus(@NotNull CopilotStatus status, @Nullable String customMessage) {
        Project project;
        boolean changed;
        boolean notify = false;
        Object object = this.lock;
        synchronized (object) {
            CopilotStatus oldStatus = this.status;
            if (!oldStatus.isDisablingClientRequests()) {
                notify = this.status != status;
                this.status = status;
                this.message = customMessage;
            }
        }
        if (status.isDisablingClientRequests() && (changed = clientRequestsDisabled.compareAndSet(false, true)) && status == CopilotStatus.IncompatibleClient && (project = ApplicationUtil.findCurrentProject()) != null) {
            ApplicationManager.getApplication().invokeLater(() -> CopilotStatusService.showRequestsDisabledNotification(project));
        }
        if (notify) {
            this.updateAllStatusBarIcons();
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private @NotNull Pair<@NotNull CopilotStatus, @Nullable String> getStatus() {
        Object object = this.lock;
        synchronized (object) {
            return Pair.create((Object)((Object)this.status), (Object)this.message);
        }
    }

    private void updateAllStatusBarIcons() {
        Runnable action2 = () -> {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                if (project.isDisposed()) continue;
                CopilotStatusBarWidget.update(project);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            action2.run();
        } else {
            application.invokeLater(action2);
        }
    }

    @RequiresEdt
    private static void showRequestsDisabledNotification(@NotNull Project project) {
        Notification notification = CopilotNotifications.createFullContentNotification(CopilotBundle.get("requestsDisabledNotification.title"), CopilotBundle.get("requestsDisabledNotification.text"), NotificationType.ERROR, true);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)CopilotBundle.get("requestsDisabledNotification.checkUpdates"), () -> new CopilotPluginUpdater.CheckUpdatesTask(project, true).queue()));
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)CopilotBundle.get("requestsDisabledNotification.hide"), (Runnable)EmptyRunnable.getInstance()));
        notification.notify(project);
    }
}

