/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.status;

import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import com.github.copilot.status.CopilotStatus;
import com.github.copilot.status.CopilotStatusListener;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\f\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/github/copilot/status/ToolBarActionMenuListener;", "Lcom/github/copilot/status/CopilotStatusListener;", "<init>", "()V", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "actionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "loggedOutToolBarActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/actionSystem/AnAction;", "loggedInToolBarActions", "toolsMenu", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "onCopilotStatus", "", "status", "Lcom/github/copilot/status/CopilotStatus;", "customMessage", "", "swapReplaceActionGroup", "oldAction", "newAction", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nToolBarActionMenuListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolBarActionMenuListener.kt\ncom/github/copilot/status/ToolBarActionMenuListener\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,47:1\n39#2:48\n*S KotlinDebug\n*F\n+ 1 ToolBarActionMenuListener.kt\ncom/github/copilot/status/ToolBarActionMenuListener\n*L\n14#1:48\n*E\n"})
public final class ToolBarActionMenuListener
implements CopilotStatusListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log;
    @NotNull
    private final ActionManager actionManager;
    private final AnAction loggedOutToolBarActions;
    private final AnAction loggedInToolBarActions;
    @NotNull
    private final DefaultActionGroup toolsMenu;
    @NotNull
    public static final String TOOLS_MENU_ID = "ToolsMenu";
    @NotNull
    public static final String LOGGED_OUT_ACTION_ID = "copilot.toolsActionGroupLoggedOut";
    @NotNull
    public static final String LOGGED_IN_ACTION_ID = "copilot.toolsActionGroupLoggedIn";

    public ToolBarActionMenuListener() {
        boolean $i$f$Logger = false;
        this.log = new GitHubLogger(ToolBarActionMenuListener.class);
        ActionManager actionManager = ActionManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)actionManager, (String)"getInstance(...)");
        this.actionManager = actionManager;
        this.loggedOutToolBarActions = this.actionManager.getAction(LOGGED_OUT_ACTION_ID);
        this.loggedInToolBarActions = this.actionManager.getAction(LOGGED_IN_ACTION_ID);
        AnAction anAction = this.actionManager.getAction(TOOLS_MENU_ID);
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
        this.toolsMenu = (DefaultActionGroup)anAction;
    }

    @Override
    public void onCopilotStatus(@NotNull CopilotStatus status, @Nullable String customMessage) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        try {
            if (status == CopilotStatus.Ready) {
                AnAction anAction = this.loggedInToolBarActions;
                Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"loggedInToolBarActions");
                AnAction anAction2 = this.loggedOutToolBarActions;
                Intrinsics.checkNotNullExpressionValue((Object)anAction2, (String)"loggedOutToolBarActions");
                this.swapReplaceActionGroup(this.toolsMenu, anAction, anAction2);
            } else {
                AnAction anAction = this.loggedOutToolBarActions;
                Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"loggedOutToolBarActions");
                AnAction anAction3 = this.loggedInToolBarActions;
                Intrinsics.checkNotNullExpressionValue((Object)anAction3, (String)"loggedInToolBarActions");
                this.swapReplaceActionGroup(this.toolsMenu, anAction, anAction3);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to update tools menu item");
        }
    }

    private final void swapReplaceActionGroup(DefaultActionGroup $this$swapReplaceActionGroup, AnAction oldAction, AnAction newAction) {
        if ($this$swapReplaceActionGroup.containsAction(oldAction)) {
            $this$swapReplaceActionGroup.remove(oldAction);
        }
        if (!$this$swapReplaceActionGroup.containsAction(newAction)) {
            $this$swapReplaceActionGroup.add(newAction);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/github/copilot/status/ToolBarActionMenuListener$Companion;", "", "<init>", "()V", "TOOLS_MENU_ID", "", "LOGGED_OUT_ACTION_ID", "LOGGED_IN_ACTION_ID", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

