/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.statusBar;

import com.github.copilot.CopilotBundle;
import com.github.copilot.settings.CopilotApplicationSettings;
import com.github.copilot.status.CopilotStatus;
import com.github.copilot.status.CopilotStatusService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopilotStatusBarWidget
extends EditorBasedStatusBarPopup {
    private static final String WIDGET_ID = "com.github.copilot.status.widget";

    public static void update(@NotNull Project project) {
        CopilotStatusBarWidget widget = CopilotStatusBarWidget.findWidget(project);
        if (widget != null) {
            widget.update(() -> widget.myStatusBar.updateWidget(WIDGET_ID));
        }
    }

    public static void showStatusPopupAtCenter(@NotNull Project project) {
        ListPopup popup;
        CopilotStatusBarWidget widget = CopilotStatusBarWidget.findWidget(project);
        if (widget != null && (popup = widget.createPopup(widget.getContext())) != null) {
            Disposer.register((Disposable)widget, (Disposable)popup);
            Dimension dimension = popup.getContent().getPreferredSize();
            JFrame frame = WindowManager.getInstance().getFrame(project);
            if (frame != null) {
                JRootPane component2 = frame.getRootPane();
                Rectangle visibleRect = component2.getVisibleRect();
                int x = visibleRect.x + visibleRect.width / 2 - dimension.width / 2;
                int y = visibleRect.y + visibleRect.height / 2 - dimension.height / 2;
                popup.show(new RelativePoint((Component)component2, new Point(x, y)));
            }
        }
    }

    public CopilotStatusBarWidget(@NotNull Project project) {
        super(project, false);
    }

    @NonNls
    @NotNull
    public String ID() {
        return WIDGET_ID;
    }

    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
        Pair<CopilotStatus, String> statusAndMessage = CopilotStatusService.getCurrentStatus();
        CopilotStatus status = (CopilotStatus)((Object)statusAndMessage.first);
        String message = (String)statusAndMessage.second;
        String toolTip = message == null ? CopilotBundle.get("statusBar.tooltipForError", status.getPresentableText()) : CopilotBundle.get("statusBar.tooltipForErrorCustomMessage", status.getPresentableText(), message);
        EditorBasedStatusBarPopup.WidgetState state = new EditorBasedStatusBarPopup.WidgetState(toolTip, "", true);
        state.setIcon(status.getIcon());
        return state;
    }

    @Nullable
    protected ListPopup createPopup(DataContext context) {
        CopilotStatus currentStatus = (CopilotStatus)((Object)CopilotStatusService.getCurrentStatus().first);
        if (currentStatus == CopilotStatus.Unsupported) {
            return null;
        }
        AnAction configuredGroup = ActionManager.getInstance().getAction(this.findPopupMenuId(currentStatus));
        if (!(configuredGroup instanceof ActionGroup)) {
            return null;
        }
        return JBPopupFactory.getInstance().createActionGroupPopup(CopilotBundle.get("statusBar.popup.title"), (ActionGroup)configuredGroup, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
    }

    @NotNull
    private String findPopupMenuId(@NotNull CopilotStatus currentStatus) {
        if (currentStatus == CopilotStatus.Ready) {
            return "copilot.statusBarPopup";
        }
        if (currentStatus.isDisablingClientRequests()) {
            return "copilot.statusBarRestartPopup";
        }
        return "copilot.statusBarErrorPopup";
    }

    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        return new CopilotStatusBarWidget(project);
    }

    @Nullable
    private Boolean isCopilotEnabled(@NotNull VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file);
        if (psiFile == null) {
            return null;
        }
        return CopilotApplicationSettings.isCopilotEnabled(psiFile.getLanguage());
    }

    @Nullable
    private static CopilotStatusBarWidget findWidget(@NotNull Project project) {
        StatusBarWidget widget;
        StatusBar bar = WindowManager.getInstance().getStatusBar(project);
        if (bar != null && (widget = bar.getWidget(WIDGET_ID)) instanceof CopilotStatusBarWidget) {
            return (CopilotStatusBarWidget)widget;
        }
        return null;
    }
}

