/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.telemetry;

import com.github.copilot.telemetry.GitHubPanicStackFrame;
import com.github.copilot.util.AnonymizeUtils;
import com.github.copilot.util.Maps;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AzureStacktraceUtil {
    private AzureStacktraceUtil() {
    }

    @NotNull
    static List<Map<String, Object>> createExceptionStackTraceTree(@NotNull Throwable throwable) {
        LinkedList<Map<String, Object>> target = new LinkedList<Map<String, Object>>();
        AzureStacktraceUtil.createExceptionStackTraceTree(target, throwable, null);
        return target;
    }

    private static void createExceptionStackTraceTree(@NotNull List<Map<String, Object>> target, @NotNull Throwable throwable, @Nullable Throwable parent) {
        target.add(AzureStacktraceUtil.createExceptionStackTrace(throwable, parent));
        Throwable cause = throwable.getCause();
        if (cause != null) {
            AzureStacktraceUtil.createExceptionStackTraceTree(target, cause, throwable);
        }
    }

    @NotNull
    private static Map<String, Object> createExceptionStackTrace(@NotNull Throwable throwable, @Nullable Throwable parent) {
        StackTraceElement[] trace = throwable.getStackTrace();
        String redactedErrorMessage = AnonymizeUtils.redactPii(throwable.getMessage());
        Map<String, Object> properties = Map.of("id", throwable.hashCode(), "typeName", throwable.getClass().getName(), "hasFullStack", trace != null && trace.length > 0, "message", StringUtil.defaultIfEmpty((String)redactedErrorMessage, (String)throwable.getClass().getName()), "parsedStack", AzureStacktraceUtil.mapStackTraceFrames(throwable));
        if (parent != null) {
            properties = Maps.merge(properties, Map.of("outerId", parent.hashCode()));
        }
        return properties;
    }

    @NotNull
    private static List<GitHubPanicStackFrame> mapStackTraceFrames(@NotNull Throwable throwable) {
        StackTraceElement[] frames = throwable.getStackTrace();
        ArrayList<GitHubPanicStackFrame> mapped = new ArrayList<GitHubPanicStackFrame>(frames.length);
        for (int i = 0; i < frames.length; ++i) {
            mapped.add(AzureStacktraceUtil.mapStackTraceFrame(i, frames[i]));
        }
        return mapped;
    }

    @NotNull
    private static GitHubPanicStackFrame mapStackTraceFrame(int i, StackTraceElement frame) {
        String className = frame.getClassName();
        String methodName = frame.getMethodName();
        String method = StringUtil.isNotEmpty((String)className) ? className + "." + methodName : methodName;
        return new GitHubPanicStackFrame(i, method, null, frame.getFileName(), frame.getLineNumber());
    }
}

