/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.telemetry;

import com.github.copilot.CopilotBundle;
import com.github.copilot.telemetry.ErrorReportService;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopilotErrorHandler
extends ErrorReportSubmitter {
    private static final Logger LOG = Logger.getInstance(CopilotErrorHandler.class);

    @NlsActions.ActionText
    @NotNull
    public String getReportActionText() {
        return CopilotBundle.get("errorHandler.reportAction.text");
    }

    public boolean submit(final IdeaLoggingEvent @NotNull [] events, final @Nullable String additionalInfo, @NotNull Component parentComponent, final @NotNull Consumer<? super SubmittedReportInfo> consumer) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(parentComponent));
        new Task.Backgroundable(project, CopilotBundle.get("errorHandler.reportDialog.title"), false){

            public void run(@NotNull ProgressIndicator indicator) {
                for (IdeaLoggingEvent event : events) {
                    Object data = event.getData();
                    if (data instanceof AbstractMessage) {
                        Throwable exception = ((AbstractMessage)data).getThrowable();
                        List attachments = ((AbstractMessage)data).getIncludedAttachments();
                        Map<String, String> properties = additionalInfo != null ? Map.of("userNotes", additionalInfo) : Map.of();
                        ErrorReportService.getInstance().reportException(exception, properties, attachments.size());
                        if (attachments.isEmpty()) continue;
                        ErrorReportService.getInstance().reportExceptionSecure(exception, properties, attachments);
                        continue;
                    }
                    LOG.warn("Unable to report error report due to missing exception: " + String.valueOf(event));
                }
                ApplicationManager.getApplication().invokeLater(() -> consumer.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.NEW_ISSUE)));
            }
        }.queue();
        return true;
    }
}

