/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.telemetry;

import com.github.copilot.CopilotPlugin;
import com.github.copilot.CopilotSessionId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.util.SystemInfoRt;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class CopilotTelemetryContext {
    static final Map<String, String> staticProperties;

    private CopilotTelemetryContext() {
    }

    @NotNull
    private static String vscodeOSName() {
        if (SystemInfoRt.isWindows) {
            return "win32";
        }
        if (SystemInfoRt.isLinux) {
            return "linux";
        }
        if (SystemInfoRt.isMac) {
            return "darwin";
        }
        return SystemInfoRt.OS_NAME;
    }

    static boolean isDeveloperMode() {
        return ApplicationManager.getApplication().isInternal();
    }

    static String build() {
        if (CopilotTelemetryContext.isDeveloperMode()) {
            return "dev";
        }
        return "";
    }

    static {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("common_vscodemachineid", PermanentInstallationID.get());
        properties.put("client_machineid", PermanentInstallationID.get());
        properties.put("common_vscodesessionid", CopilotSessionId.SESSION_ID);
        properties.put("client_sessionid", CopilotSessionId.SESSION_ID);
        properties.put("common_os", CopilotTelemetryContext.vscodeOSName());
        properties.put("common_platformversion", SystemInfoRt.OS_VERSION);
        properties.put("common_uikind", "desktop");
        properties.put("editor_plugin_version", CopilotPlugin.pluginVersionString());
        properties.put("editor_version", CopilotPlugin.editorVersionString());
        properties.put("common_extname", "copilot-intellij");
        properties.put("common_extversion", CopilotPlugin.getVersion());
        properties.put("copilot_build", CopilotTelemetryContext.build());
        properties.put("copilot_buildType", String.valueOf(CopilotTelemetryContext.isDeveloperMode()));
        staticProperties = Collections.unmodifiableMap(properties);
    }
}

