/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.telemetry;

import com.github.copilot.telemetry.GitHubPanicTelemetryService;
import com.github.copilot.telemetry.NoopTelemetryService;
import com.github.copilot.telemetry.TelemetryService;
import com.intellij.openapi.application.ApplicationManager;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class EnablingTelemetryService
implements TelemetryService {
    private final TelemetryService defaultDelegate = this.createDelegate();

    @NotNull
    private TelemetryService createDelegate() {
        boolean isCI = this.isRunningInCi();
        boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (isCI || isUnitTestMode) {
            return new NoopTelemetryService();
        }
        return new GitHubPanicTelemetryService();
    }

    @Override
    public void track(@NotNull String name, @NotNull Map<String, String> properties) {
        this.defaultDelegate.track(name, properties);
    }

    @TestOnly
    TelemetryService getDefaultDelegate() {
        return this.defaultDelegate;
    }

    @TestOnly
    boolean isRunningInCi() {
        return System.getenv("CI") != null;
    }
}

