/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.telemetry;

import com.github.copilot.telemetry.AzureStacktraceUtil;
import com.github.copilot.telemetry.CopilotTelemetryContext;
import com.github.copilot.telemetry.GitHubPanicErrorReportService;
import com.github.copilot.telemetry.TelemetryChannel;
import com.github.copilot.util.AnonymizeUtils;
import com.github.copilot.util.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class GitHubPanicEndpoint {
    private static final Logger LOG = Logger.getInstance(GitHubPanicErrorReportService.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private static final Gson GSON = new GsonBuilder().create();
    private static final String PANIC_ENDPOINT = "https://copilot-telemetry.githubusercontent.com/telemetry";

    GitHubPanicEndpoint() {
    }

    static void post(@NotNull String payload) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                HttpRequests.post((String)PANIC_ENDPOINT, (String)"application/json").write(payload);
            }
            catch (IOException e) {
                LOG.warn("error sending error report", (Throwable)e);
            }
        });
    }

    static String createSerializedExceptionPayload(@NotNull TelemetryChannel channel, @NotNull Throwable throwable, @NotNull Map<String, String> properties) {
        Map<String, String> redactedProperties = AnonymizeUtils.redactPii(properties);
        return GSON.toJson(GitHubPanicEndpoint.createExceptionPayload(channel, throwable, redactedProperties));
    }

    private static Map<String, Object> createExceptionPayload(@NotNull TelemetryChannel channel, @NotNull Throwable throwable, @NotNull Map<String, String> properties) {
        return GitHubPanicEndpoint.createPayload(channel, "Error", Map.of("baseType", "ExceptionData", "baseData", Map.of("ver", 2, "severityLevel", "Error", "exceptions", AzureStacktraceUtil.createExceptionStackTraceTree(throwable), "properties", GitHubPanicEndpoint.createBaseProperties(properties))));
    }

    static String createSerializedEventPayload(@NotNull TelemetryChannel channel, @NotNull String name, @NotNull Map<String, String> properties, @NotNull Map<String, Double> metrics) {
        return GSON.toJson(GitHubPanicEndpoint.createEventPayload(channel, name, properties, metrics));
    }

    private static Map<String, Object> createEventPayload(@NotNull TelemetryChannel channel, @NotNull String name, @NotNull Map<String, String> properties, @NotNull Map<String, Double> metrics) {
        return GitHubPanicEndpoint.createPayload(channel, "Information", Map.of("baseType", "EventData", "baseData", Map.of("ver", 2, "name", name, "properties", GitHubPanicEndpoint.createBaseProperties(properties), "measurements", metrics)));
    }

    @NotNull
    private static Map<String, Object> createPayload(@NotNull TelemetryChannel channel, @NotNull String severityLevel, @NotNull Map<String, Object> dataProperties) {
        return Map.of("ver", 1, "time", dateFormat.format(new Date()), "severityLevel", severityLevel, "name", "Microsoft.ApplicationInsights.standard.Event", "iKey", channel.getKey(), "data", dataProperties);
    }

    @NotNull
    private static Map<String, Object> createBaseProperties(@NotNull Map<String, String> properties) {
        return Maps.merge(CopilotTelemetryContext.staticProperties, properties);
    }
}

