/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.telemetry;

import com.github.copilot.lang.agent.CopilotAgent;
import com.github.copilot.lang.agent.CopilotAgentProcessService;
import com.github.copilot.lang.agent.commands.AgentErrorDetail;
import com.github.copilot.lang.agent.commands.TelemetryExceptionCommand;
import com.github.copilot.telemetry.ErrorReportService;
import com.github.copilot.telemetry.GitHubPanicEndpoint;
import com.github.copilot.telemetry.TelemetryChannel;
import com.github.copilot.util.AnonymizeUtils;
import com.github.copilot.util.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.util.ExceptionUtil;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitHubPanicErrorReportService
implements ErrorReportService {
    @Override
    public void reportException(@NotNull Throwable original, @NotNull Map<String, String> properties, int attachmentCount) {
        if (GitHubPanicErrorReportService.isAgentAvailable()) {
            this.reportWithAgent(original, properties);
        } else {
            this.reportToPanicEndpoint(TelemetryChannel.Standard, original, properties);
        }
    }

    @Override
    public void reportExceptionSecure(@NotNull Throwable original, @NotNull Map<String, String> properties, @NotNull List<Attachment> attachments) {
        this.reportToPanicEndpoint(TelemetryChannel.Restricted, original, Maps.merge(properties, GitHubPanicErrorReportService.createSecureProperties(attachments)));
    }

    protected void post(@NotNull String payload) {
        GitHubPanicEndpoint.post(payload);
    }

    private void reportToPanicEndpoint(@NotNull TelemetryChannel key, @NotNull Throwable original, @NotNull Map<String, String> properties) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            String payload = GitHubPanicEndpoint.createSerializedExceptionPayload(key, original, properties);
            this.post(payload);
        });
    }

    private void reportWithAgent(@NotNull Throwable original, @NotNull Map<String, String> properties) {
        String stacktrace = ExceptionUtil.getThrowableText((Throwable)original);
        stacktrace = AnonymizeUtils.redactPii(stacktrace);
        stacktrace = stacktrace.replaceAll("\r\n", "\n");
        AgentErrorDetail[] errorDetails = AgentErrorDetail.from(original);
        Map<String, String> redactedProperties = AnonymizeUtils.redactPii(properties);
        TelemetryExceptionCommand command = new TelemetryExceptionCommand(stacktrace, redactedProperties, errorDetails);
        CopilotAgentProcessService.getInstance().executeCommand(command).onError(throwable -> this.reportToPanicEndpoint(TelemetryChannel.Standard, (Throwable)throwable, Collections.emptyMap()));
    }

    private static boolean isAgentAvailable() {
        return CopilotAgent.isAgentSupported() && ApplicationManager.getApplication().getServiceIfCreated(CopilotAgentProcessService.class) != null && CopilotAgentProcessService.getInstance().isRunning();
    }

    @NotNull
    private static Map<String, String> createSecureProperties(@NotNull List<Attachment> attachments) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (int i = 0; i < attachments.size(); ++i) {
            Attachment attachment = attachments.get(i);
            String name = String.format("attachment_%d_%s", i, attachment.getPath().replace(' ', '_'));
            properties.put(name, new String(attachment.getBytes(), StandardCharsets.UTF_8));
        }
        String nodeOptions = System.getenv("NODE_OPTIONS");
        if (nodeOptions != null) {
            properties.put("nodeOptions", nodeOptions);
        }
        return properties;
    }
}

