/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.toolWindow;

import com.github.copilot.CopilotBundle;
import com.github.copilot.completions.CopilotCompletionService;
import com.github.copilot.completions.CopilotEditorInlay;
import com.github.copilot.completions.CopilotInlayList;
import com.github.copilot.completions.OpenCopilotSolution;
import com.github.copilot.editor.CopilotApplyInlayStrategy;
import com.github.copilot.editor.CopilotEditorManager;
import com.github.copilot.editor.InlayDisposeContext;
import com.github.copilot.github.GitHubService;
import com.github.copilot.request.EditorRequest;
import com.github.copilot.toolWindow.DataProviderPanel;
import com.github.copilot.toolWindow.OpenCopilotListener;
import com.github.copilot.toolWindow.OpenCopilotToolWindowFactory;
import com.github.copilot.toolWindow.SmallButton;
import com.github.copilot.util.RequestCancelledException;
import com.github.copilot.util.RequestTimeoutException;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.content.Content;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Flow;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OpenCopilotHandler {
    private static final Logger LOG = Logger.getInstance(OpenCopilotHandler.class);
    private static final int MAX_EDITOR_HEIGHT = 200;
    static final Key<Boolean> COPILOT_PREVIEW_EDITOR = Key.create((String)"copilot.openCopilotPreview");
    final Topic<OpenCopilotListener> OPEN_COPILOT_TOPIC = Topic.create((String)"github.openCopilot", OpenCopilotListener.class);
    private final Project project;
    private final ToolWindow toolWindow;
    private final FileType fileType;
    private final Editor hostEditor;
    @NotNull
    private final EditorRequest editorRequest;
    private final DataProviderPanel contentPanel;
    private final List<OpenCopilotSolution> sortedSolutions = Collections.synchronizedList(new ArrayList());
    private final List<JButton> allButtons = ContainerUtil.createLockFreeCopyOnWriteList();
    private volatile Content toolWindowContent;

    @Nullable
    static OpenCopilotHandler create(@NotNull Project project, @NotNull FileType fileType, @NotNull Editor editor, @NotNull EditorRequest request) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("github.copilotToolWindow");
        if (toolWindow == null) {
            return null;
        }
        return new OpenCopilotHandler(project, toolWindow, fileType, editor, request);
    }

    static boolean isCopilotSnippetFile(@NotNull VirtualFile virtualFile) {
        return COPILOT_PREVIEW_EDITOR.isIn((UserDataHolder)virtualFile);
    }

    OpenCopilotHandler(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull FileType fileType, @NotNull Editor hostEditor, @NotNull EditorRequest editorRequest) {
        this.project = project;
        this.toolWindow = toolWindow;
        this.fileType = fileType;
        this.hostEditor = hostEditor;
        this.editorRequest = editorRequest;
        this.contentPanel = new DataProviderPanel(toolWindow.getDisposable());
        Disposer.tryRegister((Disposable)toolWindow.getDisposable(), (Disposable)editorRequest.getDisposable());
    }

    void updateToolWindow() {
        this.contentPanel.setFocusCycleRoot(true);
        this.contentPanel.setBorder(JBUI.Borders.empty((int)3));
        this.toolWindowContent = this.toolWindow.getContentManager().getFactory().createContent((JComponent)new JBScrollPane((Component)((Object)this.contentPanel), 20, 31), null, false);
        this.toolWindow.getContentManager().addContent(this.toolWindowContent);
        Disposer.tryRegister((Disposable)this.editorRequest.getDisposable(), this::setEditorChangedEmptyText);
        if (!GitHubService.getInstance().isSignedIn()) {
            this.setContentEmptyText(CopilotBundle.get("openCopilot.notAuthenticatedError"), SimpleTextAttributes.ERROR_ATTRIBUTES);
            return;
        }
        this.setContentEmptyText(CopilotBundle.get("openCopilot.calculatingEmptyText"), null);
        CopilotCompletionService service = CopilotCompletionService.getInstance();
        boolean sent = service.fetchOpenCopilotSolutions(this.editorRequest, new Flow.Subscriber<List<OpenCopilotSolution>>(){
            private volatile Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription2) {
                this.subscription = subscription2;
                this.subscription.request(1L);
            }

            @Override
            public void onNext(List<OpenCopilotSolution> solutions) {
                LOG.debug("onNext: " + solutions.size());
                this.subscription.request(1L);
                Comparator<OpenCopilotSolution> comparator = Comparator.comparingInt(OpenCopilotSolution::getScore).reversed();
                for (OpenCopilotSolution solution : solutions) {
                    OpenCopilotSolution existingSolution = OpenCopilotHandler.this.findExistingSolutionByHash(solution);
                    if (existingSolution != null && solution.getScore() <= existingSolution.getScore()) continue;
                    OpenCopilotHandler.this.sortedSolutions.add(solution);
                    OpenCopilotHandler.this.sortedSolutions.sort(comparator);
                    int panelIndex = Collections.binarySearch(OpenCopilotHandler.this.sortedSolutions, solution, comparator);
                    if (panelIndex < 0) {
                        panelIndex = 0;
                    } else if (panelIndex == OpenCopilotHandler.this.sortedSolutions.size()) {
                        panelIndex = -1;
                    }
                    OpenCopilotHandler.this.addSolution((JPanel)((Object)OpenCopilotHandler.this.contentPanel), solution, panelIndex, existingSolution != null);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(throwable);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Error fetching solutions: " + throwable.getMessage());
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (OpenCopilotHandler.this.project.isDisposed()) {
                        return;
                    }
                    if (throwable instanceof RequestCancelledException) {
                        if (!OpenCopilotHandler.this.editorRequest.isCancelled()) {
                            OpenCopilotHandler.this.setEditorChangedEmptyText();
                        }
                    } else if (throwable instanceof RequestTimeoutException) {
                        OpenCopilotHandler.this.setContentEmptyText(CopilotBundle.get("openCopilot.requestTimeoutError"), SimpleTextAttributes.ERROR_ATTRIBUTES);
                    } else {
                        OpenCopilotHandler.this.setContentEmptyText(CopilotBundle.get("openCopilot.unknownRequestError"), SimpleTextAttributes.ERROR_ATTRIBUTES);
                    }
                });
            }

            @Override
            public void onComplete() {
                LOG.debug("onComplete");
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (OpenCopilotHandler.this.project.isDisposed()) {
                        return;
                    }
                    if (OpenCopilotHandler.this.sortedSolutions.isEmpty() && !OpenCopilotHandler.this.editorRequest.isCancelled()) {
                        OpenCopilotHandler.this.setContentEmptyText(CopilotBundle.get("openCopilot.noCompletions"), SimpleTextAttributes.ERROR_ATTRIBUTES);
                    } else if (OpenCopilotHandler.this.toolWindowContent != null && OpenCopilotHandler.this.toolWindowContent.isValid()) {
                        OpenCopilotHandler.this.toolWindow.getContentManager().requestFocus(OpenCopilotHandler.this.toolWindowContent, false);
                    }
                    ((OpenCopilotListener)OpenCopilotHandler.this.project.getMessageBus().syncPublisher(OpenCopilotHandler.this.OPEN_COPILOT_TOPIC)).openCopilotCompleted(OpenCopilotHandler.this.sortedSolutions.size());
                });
            }
        });
        if (!sent) {
            this.setContentEmptyText(CopilotBundle.get("openCopilot.noCompletions"), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    @Nullable
    private OpenCopilotSolution findExistingSolutionByHash(@NotNull OpenCopilotSolution newSolution) {
        for (OpenCopilotSolution existingSolution : this.sortedSolutions) {
            if (!newSolution.getHash().equals(existingSolution.getHash())) continue;
            return existingSolution;
        }
        return null;
    }

    @RequiresBackgroundThread
    private void addSolution(@NotNull JPanel contentPanel2, final @NotNull OpenCopilotSolution solution, int solutionPanelIndex, boolean replaceExisting) {
        LightVirtualFile snippetFile = OpenCopilotHandler.createPreviewVirtualFile(this.fileType, this.editorRequest.getFileLanguage().getLanguage(), OpenCopilotHandler.getSolutionLines(solution));
        ApplicationManager.getApplication().invokeLater(() -> {
            EditorTextField editor = this.createSnippetEditor(snippetFile);
            this.clearContentEmptyText();
            SmallButton acceptButton = new SmallButton(CopilotBundle.get("openCopilot.solution.accept"));
            acceptButton.addFocusListener(new ButtonFocusListener(acceptButton, contentPanel2, editor));
            acceptButton.addActionListener(actionEvent -> this.acceptSolution(this.project, this.editorRequest, solution.getInlays()));
            acceptButton.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        OpenCopilotHandler.this.acceptSolution(OpenCopilotHandler.this.project, OpenCopilotHandler.this.editorRequest, solution.getInlays());
                    } else {
                        super.keyPressed(e);
                    }
                }
            });
            JPanel header = new JPanel((LayoutManager)new HorizontalLayout(0));
            header.add(acceptButton);
            JPanel solutionPanel = new JPanel((LayoutManager)new VerticalLayout(0));
            solutionPanel.add(header);
            solutionPanel.add((Component)editor);
            if (replaceExisting) {
                assert (solutionPanelIndex >= 0);
                contentPanel2.remove(solutionPanelIndex);
            }
            contentPanel2.add((Component)solutionPanel, solutionPanelIndex);
            if (this.allButtons.isEmpty()) {
                acceptButton.requestFocusInWindow();
            }
            this.allButtons.add(acceptButton);
            Dimension editorPreferredSize = contentPanel2.getPreferredSize();
            editor.setMaximumSize((Dimension)new JBDimension(0, 200));
            Editor wrappedEditor = editor.getEditor();
            if (wrappedEditor != null) {
                wrappedEditor.getScrollingModel().scrollVertically(0);
                int contentHeight = wrappedEditor instanceof EditorEx ? ((EditorEx)wrappedEditor).getContentSize().height : wrappedEditor.getContentComponent().getHeight();
                int height = Math.min(200, contentHeight += wrappedEditor.getLineHeight());
                editor.setPreferredSize(new Dimension(editorPreferredSize.width, height));
            }
            editor.invalidate();
        });
    }

    @NotNull
    private EditorTextField createSnippetEditor(@NotNull LightVirtualFile snippetFile) {
        Language language = snippetFile.getLanguage();
        if (language == null) {
            throw new IllegalStateException("Preview file must have a language. File: " + String.valueOf(snippetFile) + ", file type: " + String.valueOf(snippetFile.getFileType()));
        }
        EditorTextField editor = EditorTextFieldProvider.getInstance().getEditorField(language, this.project, List.of(editorEx -> {
            EditorSettings editorSettings2 = editorEx.getSettings();
            editorSettings2.setLineNumbersShown(false);
            editorSettings2.setLineMarkerAreaShown(false);
            editorSettings2.setAutoCodeFoldingEnabled(false);
            editorSettings2.setUseSoftWraps(true);
            editorSettings2.setAnimatedScrolling(false);
            editorSettings2.setBlinkCaret(false);
            editorSettings2.setRightMarginShown(false);
            editorSettings2.setShowIntentionBulb(false);
            editorEx.setViewer(true);
            editorEx.setCaretVisible(false);
            editorEx.setCaretEnabled(false);
            editorEx.putUserData(IncrementalFindAction.SEARCH_DISABLED, (Object)Boolean.TRUE);
            editorEx.setRendererMode(false);
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
            Color c = scheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            editorEx.setBackgroundColor(c != null ? c : scheme.getDefaultBackground());
            editorEx.setColorsScheme(scheme);
        }));
        FileViewProvider snippetViewProvider = PsiManager.getInstance((Project)this.project).findViewProvider((VirtualFile)snippetFile);
        if (snippetViewProvider != null) {
            editor.setDocument(snippetViewProvider.getDocument());
        }
        editor.setViewer(true);
        editor.addFocusListener(this.editorFocusListener(editor));
        return editor;
    }

    private FocusListener editorFocusListener(final @NotNull EditorTextField editor) {
        return new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                editor.setBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Focus.focusColor(), (int)1));
            }

            @Override
            public void focusLost(FocusEvent e) {
                editor.setBorder(null);
            }
        };
    }

    private void acceptSolution(@NotNull Project project, @NotNull EditorRequest editorRequest, @NotNull CopilotInlayList completion) {
        Content content = this.toolWindowContent;
        if (content != null) {
            this.toolWindow.getContentManager().removeContent(content, true);
            this.toolWindowContent = null;
        }
        this.toolWindow.hide();
        FileEditor mainEditor = FileEditorManagerEx.getInstanceEx((Project)project).getSelectedEditor();
        if (!(mainEditor instanceof TextEditor)) {
            return;
        }
        CopilotEditorManager manager = CopilotEditorManager.getInstance();
        Editor textEditor = ((TextEditor)mainEditor).getEditor();
        manager.disposeInlays(textEditor, InlayDisposeContext.UserAction);
        manager.applyCompletion(project, textEditor, editorRequest, completion, CopilotApplyInlayStrategy.WHOLE);
    }

    private void setEditorChangedEmptyText() {
        Content content = this.toolWindowContent;
        if (content != null && content.isValid()) {
            this.setContentEmptyText(CopilotBundle.get("openCopilot.editorChangedError"), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    private void clearContentEmptyText() {
        this.contentPanel.getEmptyText().clear();
        this.contentPanel.setCursor(Cursor.getDefaultCursor());
    }

    private void setContentEmptyText(@NotNull String text, @Nullable SimpleTextAttributes attrs) {
        this.contentPanel.removeAll();
        this.contentPanel.getEmptyText().clear();
        if (attrs == null) {
            this.contentPanel.getEmptyText().setText(text);
        } else {
            this.contentPanel.getEmptyText().setText(text, attrs);
        }
        OpenCopilotToolWindowFactory.appendRefreshLine(this.contentPanel.getEmptyText(), this.hostEditor);
    }

    @NotNull
    private static CharSequence getSolutionLines(@NotNull OpenCopilotSolution solution) {
        StringBuilder content = new StringBuilder();
        for (CopilotEditorInlay inlay : solution.getInlays()) {
            for (String line : inlay.getLines()) {
                content.append(line).append("\n");
            }
        }
        return content;
    }

    @NotNull
    static LightVirtualFile createPreviewVirtualFile(@NotNull FileType fileType, @NotNull Language language, @NotNull CharSequence content) {
        LightVirtualFile snippetFile = new LightVirtualFile("", language, content);
        snippetFile.setFileType(fileType);
        snippetFile.setWritable(false);
        COPILOT_PREVIEW_EDITOR.set((UserDataHolder)snippetFile, (Object)true);
        return snippetFile;
    }

    private static class ButtonFocusListener
    extends FocusAdapter {
        private final SmallButton acceptButton;
        @NotNull
        private final JPanel contentPanel;
        private final EditorTextField editor;

        private ButtonFocusListener(SmallButton acceptButton, @NotNull JPanel contentPanel2, @NotNull EditorTextField editor) {
            this.acceptButton = acceptButton;
            this.contentPanel = contentPanel2;
            this.editor = editor;
        }

        @Override
        public void focusGained(FocusEvent e) {
            FocusEvent.Cause cause = e.getCause();
            if (cause != FocusEvent.Cause.TRAVERSAL_BACKWARD && cause != FocusEvent.Cause.TRAVERSAL_FORWARD) {
                return;
            }
            Rectangle buttonRect = this.acceptButton.getBounds();
            Point buttonPos = SwingUtilities.convertPoint(this.acceptButton, buttonRect.getLocation(), this.contentPanel);
            buttonRect.setLocation(buttonPos);
            Rectangle editorRect = this.editor.getBounds();
            Point editorPos = SwingUtilities.convertPoint((Component)this.editor, editorRect.getLocation(), this.contentPanel);
            editorRect.setLocation(editorPos);
            this.contentPanel.scrollRectToVisible(buttonRect.union(editorRect));
        }
    }
}

