/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.toolWindow;

import com.github.copilot.CopilotBundle;
import com.github.copilot.actions.RefreshCopilotToolWindowAction;
import com.github.copilot.editor.CopilotEditorManager;
import com.github.copilot.editor.CopilotEditorUtil;
import com.github.copilot.toolWindow.OpenCopilotToolWindowManager;
import com.github.copilot.toolWindow.ToolWindowUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ui.StatusText;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenCopilotToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    static final String ID = "github.copilotToolWindow";

    public void init(@NotNull ToolWindow toolWindow) {
        Project project;
        RefreshCopilotToolWindowAction action2 = new RefreshCopilotToolWindowAction();
        toolWindow.setShowStripeButton(false);
        toolWindow.setTitleActions(Collections.singletonList(action2));
        action2.registerCustomShortcutSet(toolWindow.getComponent(), toolWindow.getDisposable());
        Project project2 = project = toolWindow instanceof ToolWindowEx ? ((ToolWindowEx)toolWindow).getProject() : null;
        if (project != null) {
            toolWindow.addContentManagerListener(new ContentManagerListener(){

                public void contentRemoved(@NotNull ContentManagerEvent event) {
                    Editor editor = CopilotEditorUtil.getSelectedEditorSafely(project);
                    OpenCopilotToolWindowFactory.refreshEmptyText(project, editor);
                }
            });
        }
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Editor editor = CopilotEditorUtil.getSelectedEditorSafely(project);
        OpenCopilotToolWindowFactory.editorSelectionChanged(project, editor);
    }

    public static void editorSelectionChanged(@NotNull Project project, @Nullable Editor newEditor) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ID);
        if (toolWindow == null) {
            return;
        }
        toolWindow.getContentManager().removeAllContents(true);
        OpenCopilotToolWindowFactory.refreshEmptyText(project, newEditor);
    }

    static void refreshEmptyText(@NotNull Project project, @Nullable Editor editor) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ID);
        if (toolWindow == null) {
            return;
        }
        StatusText emptyText = ToolWindowUtil.getEmptyText(toolWindow);
        if (emptyText == null) {
            return;
        }
        emptyText.clear();
        if (editor != null) {
            boolean available = CopilotEditorManager.getInstance().isAvailable(editor);
            if (available) {
                emptyText.setText(CopilotBundle.get("openCopilot.refreshHint"));
                OpenCopilotToolWindowFactory.appendRefreshLine(emptyText, editor);
            } else {
                emptyText.setText(CopilotBundle.get("openCopilot.unavailableForEditor"));
            }
        } else {
            emptyText.setText(CopilotBundle.get("openCopilot.unavailableNoEditor"));
        }
    }

    static void appendRefreshLine(@NotNull StatusText emptyText, @NotNull Editor editor) {
        if (editor.isDisposed()) {
            return;
        }
        emptyText.appendLine(CopilotBundle.get("openCopilot.refreshLabel"), SimpleTextAttributes.LINK_ATTRIBUTES, e -> OpenCopilotToolWindowManager.getInstance().openCopilot(editor, true));
    }
}

