/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.ui.animation;

import com.github.copilot.ui.animation.AnimationManager;
import com.github.copilot.ui.animation.strategy.AnimationStrategy;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\n\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0012\u0010\u0013\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/github/copilot/ui/animation/Animator;", "Ljava/awt/event/ActionListener;", "strategy", "Lcom/github/copilot/ui/animation/strategy/AnimationStrategy;", "duration", "", "component", "Ljavax/swing/JComponent;", "<init>", "(Lcom/github/copilot/ui/animation/strategy/AnimationStrategy;ILjavax/swing/JComponent;)V", "start", "end", "steps", "step", "delay", "timer", "Ljavax/swing/Timer;", "", "stop", "actionPerformed", "e", "Ljava/awt/event/ActionEvent;", "translate", "progress", "", "core"})
public final class Animator
implements ActionListener {
    @NotNull
    private final AnimationStrategy strategy;
    @NotNull
    private final JComponent component;
    private final int start;
    private final int end;
    private final int steps;
    private int step;
    private final int delay;
    @Nullable
    private final Timer timer;

    public Animator(@NotNull AnimationStrategy strategy, int duration, @NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.strategy = strategy;
        this.component = component2;
        this.start = this.component.getLocation().y + this.strategy.getTranslation();
        this.end = this.component.getLocation().y;
        this.steps = 100;
        this.delay = duration / this.steps;
        this.timer = ApplicationManager.getApplication().isUnitTestMode() ? null : new Timer(this.delay, this);
    }

    public final void start() {
        block1: {
            if (AnimationManager.INSTANCE.isLocked(this.component)) {
                return;
            }
            AnimationManager.INSTANCE.lock(this.component);
            Timer timer = this.timer;
            if (timer == null) break block1;
            timer.start();
        }
    }

    public final void stop() {
        Timer timer = this.timer;
        if (timer != null) {
            timer.stop();
        }
        AnimationManager.INSTANCE.unlock(this.component);
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent e) {
        float progress = (float)this.step / (float)this.steps;
        this.translate(progress);
        int n = this.step;
        this.step = n + 1;
        if (this.step >= this.steps) {
            this.component.setLocation(this.component.getLocation().x, this.end);
            Timer timer = this.timer;
            if (timer != null) {
                timer.stop();
            }
            AnimationManager.INSTANCE.unlock(this.component);
        }
    }

    private final void translate(float progress) {
        int y = this.start - this.strategy.position(progress);
        this.component.setLocation(this.component.getLocation().x, y);
    }
}

