/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.ui.component;

import com.github.copilot.platform.utils.observability.GitHubLogger;
import com.github.copilot.platform.utils.observability.Logger;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/copilot/ui/component/TruncateLeftLabel;", "Ljavax/swing/JLabel;", "text", "", "log", "Lcom/github/copilot/platform/utils/observability/Logger;", "<init>", "(Ljava/lang/String;Lcom/github/copilot/platform/utils/observability/Logger;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "core"})
@SourceDebugExtension(value={"SMAP\nTruncateLeftLabel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TruncateLeftLabel.kt\ncom/github/copilot/ui/component/TruncateLeftLabel\n+ 2 Logger.kt\ncom/github/copilot/platform/utils/observability/LoggerKt\n*L\n1#1,44:1\n39#2:45\n*S KotlinDebug\n*F\n+ 1 TruncateLeftLabel.kt\ncom/github/copilot/ui/component/TruncateLeftLabel\n*L\n10#1:45\n*E\n"})
public final class TruncateLeftLabel
extends JLabel {
    @NotNull
    private final Logger log;

    public TruncateLeftLabel(@Nullable String text, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        super(text);
        this.log = log;
        this.setFont(new Font("JetBrains Mono", 0, this.getFont().getSize()));
    }

    public /* synthetic */ TruncateLeftLabel(String string, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            boolean $i$f$Logger = false;
            logger = new GitHubLogger(TruncateLeftLabel.class);
        }
        this(string, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D g2d = (Graphics2D)g;
        FontMetrics fontMetrics = g2d.getFontMetrics();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        String finalText = "";
        try {
            Object object;
            int textWidth = fontMetrics.stringWidth(this.getText());
            int labelWidth = this.getWidth();
            if (textWidth > labelWidth) {
                String string = this.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                char[] cArray = string.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                int chars = fontMetrics.charsWidth(cArray, 0, this.getText().length());
                int visibleChars = this.getText().length() * labelWidth / chars;
                int startIndex = this.getText().length() - visibleChars + 3;
                if (startIndex < this.getText().length()) {
                    String string2 = this.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    String string3 = string2.substring(startIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                    object = "..." + string3;
                } else {
                    object = "";
                }
            } else {
                String string = this.getText();
                Intrinsics.checkNotNull((Object)string);
                object = string;
            }
            finalText = object;
        }
        catch (Exception e) {
            this.log.warn("Failed to paint component: " + e);
        }
        finally {
            g2d.drawString(finalText, 0, this.getHeight() - fontMetrics.getDescent());
        }
    }
}

