/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.ui.manager;

import com.github.copilot.ui.manager.ScrollingManager;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/github/copilot/ui/manager/StickyScrollingManager;", "Lcom/github/copilot/ui/manager/ScrollingManager;", "target", "Ljavax/swing/JComponent;", "scrollPane", "Ljavax/swing/JScrollPane;", "isSticky", "", "<init>", "(Ljavax/swing/JComponent;Ljavax/swing/JScrollPane;Z)V", "lastVerticalValue", "", "debounceCount", "currentDebounceCount", "core"})
public final class StickyScrollingManager
extends ScrollingManager {
    @NotNull
    private final JComponent target;
    @NotNull
    private final JScrollPane scrollPane;
    private boolean isSticky;
    private int lastVerticalValue;
    private final int debounceCount;
    private int currentDebounceCount;

    public StickyScrollingManager(@NotNull JComponent target, @NotNull JScrollPane scrollPane, boolean isSticky) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)scrollPane, (String)"scrollPane");
        super(scrollPane);
        this.target = target;
        this.scrollPane = scrollPane;
        this.isSticky = isSticky;
        this.debounceCount = 2;
        this.scrollPane.getVerticalScrollBar().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point point;
                MouseEvent mouseEvent = e;
                Point point2 = point = mouseEvent != null ? mouseEvent.getPoint() : null;
                if (point != null) {
                    isSticky = point.y >= scrollPane.getVerticalScrollBar().getMaximum() - scrollPane.getVerticalScrollBar().getHeight();
                    currentDebounceCount = 0;
                }
            }
        });
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(arg_0 -> StickyScrollingManager._init_$lambda$0(this, arg_0));
        ComponentAdapter scrollOnResizeListener2 = new ComponentAdapter(this){
            final /* synthetic */ StickyScrollingManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(ComponentEvent e) {
                if (StickyScrollingManager.access$isSticky$p(this.this$0)) {
                    this.this$0.scrollToBottom();
                }
            }
        };
        this.scrollPane.getVerticalScrollBar().addComponentListener(scrollOnResizeListener2);
        this.target.addComponentListener(scrollOnResizeListener2);
    }

    public /* synthetic */ StickyScrollingManager(JComponent jComponent, JScrollPane jScrollPane, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(jComponent, jScrollPane, bl);
    }

    private static final void _init_$lambda$0(StickyScrollingManager this$0, AdjustmentEvent it) {
        if (this$0.lastVerticalValue > it.getValue()) {
            ++this$0.currentDebounceCount;
        } else {
            if (it.getValue() >= this$0.scrollPane.getVerticalScrollBar().getMaximum() - this$0.scrollPane.getVerticalScrollBar().getHeight()) {
                this$0.isSticky = true;
            }
            this$0.currentDebounceCount = 0;
        }
        if (this$0.currentDebounceCount >= this$0.debounceCount) {
            this$0.isSticky = false;
            this$0.currentDebounceCount = 0;
        }
        this$0.lastVerticalValue = it.getValue();
    }

    public static final /* synthetic */ boolean access$isSticky$p(StickyScrollingManager $this) {
        return $this.isSticky;
    }
}

