/*
 * Decompiled with CFR 0.152.
 */
package com.github.copilot.update;

import com.github.copilot.CopilotBundle;
import com.github.copilot.CopilotNotifications;
import com.github.copilot.settings.CopilotLocalApplicationSettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopilotNightlyAgentChannelStartupActivity
implements ProjectActivity {
    private static final Logger LOG = Logger.getInstance(CopilotNightlyAgentChannelStartupActivity.class);
    private static final String AGENT_NIGHTLY_CHANNEL = "https://plugins.jetbrains.com/plugins/nightly-agent/17718";
    private static final String NIGHTLY_CHANNEL = "https://plugins.jetbrains.com/plugins/nightly/17718";
    private final AtomicBoolean hasRun = new AtomicBoolean(false);

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> continuation) {
        if (!this.hasRun.compareAndSet(false, true) || ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (!CopilotLocalApplicationSettings.settings().checkAgentNightlyChannel) {
            return null;
        }
        List hostListCopy = UpdateSettings.getInstance().getPluginHosts();
        if (!hostListCopy.contains(AGENT_NIGHTLY_CHANNEL)) {
            return null;
        }
        Notification notification = CopilotNotifications.createFullContentNotification(CopilotBundle.get("nightlyChannelNotification.title"), CopilotBundle.get("nightlyChannelNotification.message"), NotificationType.WARNING, true);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)CopilotBundle.get("nightlyChannelNotification.removeChannelButton"), () -> {
            CopilotLocalApplicationSettings.settings().checkAgentNightlyChannel = false;
            boolean ok = UpdateSettings.getInstance().getStoredPluginHosts().removeIf(AGENT_NIGHTLY_CHANNEL::equals);
            if (!ok) {
                LOG.warn("Failed to remove the nightly-agent channel: " + String.valueOf(hostListCopy));
            }
            UpdateSettings.getInstance().getStoredPluginHosts().add(NIGHTLY_CHANNEL);
        }));
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)CopilotBundle.get("nightlyChannelNotification.hideButton"), () -> {
            CopilotLocalApplicationSettings.settings().checkAgentNightlyChannel = false;
        }));
        notification.notify(project);
        return null;
    }
}

